/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.consensus;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.proto.ConsensusMessageChunkInfo;
import com.hedera.hashgraph.proto.ConsensusServiceGrpc;
import com.hedera.hashgraph.proto.ConsensusSubmitMessageTransactionBody;
import com.hedera.hashgraph.proto.TransactionBody;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.HederaNetworkException;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.LocalValidationException;
import com.hedera.hashgraph.sdk.SingleTransactionBuilder;
import com.hedera.hashgraph.sdk.Transaction;
import com.hedera.hashgraph.sdk.TransactionBuilder;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionList;
import com.hedera.hashgraph.sdk.consensus.ConsensusTopicId;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ConsensusMessageSubmitTransaction
extends TransactionBuilder<TransactionId, TransactionList, ConsensusMessageSubmitTransaction> {
    private static final int CHUNK_SIZE = 4096;
    @Nullable
    private ConsensusTopicId topicId;
    @Nullable
    private ConsensusMessageChunkInfo chunkInfo;
    private ByteString message = ByteString.EMPTY;
    private int maxChunks = 10;

    public ConsensusMessageSubmitTransaction setTopicId(ConsensusTopicId topicId) {
        this.topicId = topicId;
        return this;
    }

    public ConsensusMessageSubmitTransaction setMaxChunks(int maxChunks) {
        this.maxChunks = maxChunks;
        return this;
    }

    public ConsensusMessageSubmitTransaction setChunkInfo(TransactionId initialTransactionId, int totalNumber, int number) {
        this.chunkInfo = ConsensusMessageChunkInfo.newBuilder().setInitialTransactionID(initialTransactionId.toProto()).setNumber(number).setTotal(totalNumber).build();
        return this;
    }

    public ConsensusMessageSubmitTransaction setMessage(byte[] message) {
        this.message = ByteString.copyFrom((byte[])message);
        return this;
    }

    public ConsensusMessageSubmitTransaction setMessage(String message) {
        this.message = ByteString.copyFromUtf8((String)message);
        return this;
    }

    @Override
    protected void doValidate() {
        this.require(this.topicId != null, "setTopicId() required");
    }

    public List<TransactionId> executeAll(Client client) throws HederaStatusException, HederaNetworkException {
        return this.build(client).executeAll(client);
    }

    @Override
    public TransactionId execute(Client client) throws HederaStatusException, HederaNetworkException {
        return this.build(client).execute(client);
    }

    @Override
    public TransactionList build(@Nullable Client client) throws LocalValidationException {
        TransactionId initialTransactionId;
        if (this.chunkInfo != null) {
            SingleConsensusMessageSubmitTransaction singleTransaction = new SingleConsensusMessageSubmitTransaction(this.bodyBuilder.buildPartial(), this.topicId, this.chunkInfo, this.message);
            return new TransactionList(Collections.singleton(singleTransaction.build(client)));
        }
        if (!this.bodyBuilder.hasTransactionID()) {
            if (client == null || client.getOperatorId() == null) {
                throw new IllegalStateException("client must have an operator or set a transaction ID to build a consensus message transaction");
            }
            initialTransactionId = new TransactionId(client.getOperatorId());
        } else {
            initialTransactionId = new TransactionId(this.bodyBuilder.getTransactionID());
        }
        long totalMessageSize = this.message.size();
        long requiredChunks = (totalMessageSize + 4095L) / 4096L;
        if (requiredChunks > (long)this.maxChunks) {
            throw new IllegalArgumentException("message of " + totalMessageSize + " bytes requires " + requiredChunks + " chunks but the maximum allowed chunks is " + this.maxChunks + ", try using setMaxChunks");
        }
        ArrayList<Transaction> txs = new ArrayList<Transaction>();
        TransactionId nextTransactionId = initialTransactionId;
        int i = 0;
        while ((long)i < requiredChunks) {
            int startIndex = i * 4096;
            int endIndex = startIndex + 4096;
            if ((long)endIndex > totalMessageSize) {
                endIndex = (int)totalMessageSize;
            }
            ByteString chunkMessage = this.message.substring(startIndex, endIndex);
            this.bodyBuilder.setTransactionID(nextTransactionId.toProto());
            txs.add(new SingleConsensusMessageSubmitTransaction(this.bodyBuilder.buildPartial(), this.topicId, requiredChunks > 1L ? ConsensusMessageChunkInfo.newBuilder().setInitialTransactionID(initialTransactionId.toProto()).setTotal((int)requiredChunks).setNumber(i + 1).build() : null, chunkMessage).build(client));
            nextTransactionId = TransactionId.withValidStart(nextTransactionId.accountId, nextTransactionId.validStart.plusNanos(1L));
            ++i;
        }
        return new TransactionList(txs);
    }

    @Override
    protected MethodDescriptor<com.hedera.hashgraph.proto.Transaction, TransactionResponse> getMethod() {
        return ConsensusServiceGrpc.getSubmitMessageMethod();
    }

    @Override
    public com.hedera.hashgraph.proto.Transaction toProto() {
        throw new IllegalStateException("do not call toProto() on ConsensusMessageSubmitTransaction; call build() first");
    }

    @Override
    protected TransactionId mapResponse(TransactionResponse response) throws HederaStatusException {
        throw new IllegalStateException("do not call mapResponse() on ConsensusMessageSubmitTransaction; call build() first");
    }

    static class SingleConsensusMessageSubmitTransaction
    extends SingleTransactionBuilder<SingleConsensusMessageSubmitTransaction> {
        SingleConsensusMessageSubmitTransaction(TransactionBody bodyBuilder, @Nullable ConsensusTopicId topicId, ConsensusMessageChunkInfo chunkInfo, ByteString message) {
            this.bodyBuilder.mergeFrom(bodyBuilder);
            ConsensusSubmitMessageTransactionBody.Builder builder = this.bodyBuilder.getConsensusSubmitMessageBuilder();
            if (topicId != null) {
                builder.setTopicID(topicId.toProto());
            }
            if (chunkInfo != null) {
                builder.setChunkInfo(chunkInfo);
            }
            builder.setMessage(message);
        }

        @Override
        protected void doValidate() {
        }

        @Override
        protected MethodDescriptor<com.hedera.hashgraph.proto.Transaction, TransactionResponse> getMethod() {
            return ConsensusServiceGrpc.getSubmitMessageMethod();
        }
    }
}

