/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.contract;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.proto.ContractCallLocalQuery;
import com.hedera.hashgraph.proto.Query;
import com.hedera.hashgraph.proto.QueryHeader;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.HederaNetworkException;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.HederaThrowable;
import com.hedera.hashgraph.sdk.QueryBuilder;
import com.hedera.hashgraph.sdk.contract.ContractFunctionParams;
import com.hedera.hashgraph.sdk.contract.ContractFunctionResult;
import com.hedera.hashgraph.sdk.contract.ContractId;
import io.grpc.MethodDescriptor;
import java.util.function.Consumer;

public class ContractCallQuery
extends QueryBuilder<ContractFunctionResult, ContractCallQuery> {
    private final ContractCallLocalQuery.Builder builder;

    public ContractCallQuery() {
        this.builder = this.inner.getContractCallLocalBuilder();
    }

    @Override
    protected QueryHeader.Builder getHeaderBuilder() {
        return this.builder.getHeaderBuilder();
    }

    @Override
    protected MethodDescriptor<Query, Response> getMethod() {
        return SmartContractServiceGrpc.getContractCallLocalMethodMethod();
    }

    public ContractCallQuery setContractId(ContractId id) {
        this.builder.setContractID(id.toProto());
        return this;
    }

    public ContractCallQuery setGas(long gas) {
        this.builder.setGas(gas);
        return this;
    }

    @Override
    public long getCost(Client client) throws HederaStatusException, HederaNetworkException {
        return (long)((double)super.getCost(client) * 1.1);
    }

    @Override
    public void getCostAsync(Client client, Consumer<Long> withCost, Consumer<HederaThrowable> onError) {
        super.getCostAsync(client, cost -> withCost.accept((long)((double)cost.longValue() * 1.1)), onError);
    }

    public ContractCallQuery setFunctionParams(byte[] parameters) {
        this.builder.setFunctionParameters(ByteString.copyFrom((byte[])parameters));
        return this;
    }

    public ContractCallQuery setFunction(String funcName) {
        return this.setFunction(funcName, new ContractFunctionParams());
    }

    public ContractCallQuery setFunction(String funcName, ContractFunctionParams params) {
        this.builder.setFunctionParameters(params.toBytes(funcName));
        return this;
    }

    public ContractCallQuery setMaxResultSize(long size) {
        this.builder.setMaxResultSize(size);
        return this;
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasContractID(), ".setContractId() required");
    }

    @Override
    protected ContractFunctionResult extractResponse(Response raw) {
        if (raw.hasContractCallLocal()) {
            return new ContractFunctionResult(raw.getContractCallLocal().getFunctionResultOrBuilder());
        }
        throw new IllegalStateException("response case not ContractCallLocal: " + (Object)((Object)raw.getResponseCase()));
    }
}

