/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.contract;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bouncycastle.jcajce.provider.digest.Keccak;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="we don't care about the contents of `finished`")
public final class ContractFunctionSelector {
    @Nullable
    private Keccak.Digest256 digest = new Keccak.Digest256();
    private boolean needsComma = false;
    @Nullable
    private byte[] finished = null;

    public ContractFunctionSelector(String funcName) {
        this.digest.update(funcName.getBytes(StandardCharsets.US_ASCII));
        this.digest.update((byte)40);
    }

    public ContractFunctionSelector addString() {
        return this.addParamType("string");
    }

    public ContractFunctionSelector addStringArray() {
        return this.addParamType("string[]");
    }

    public ContractFunctionSelector addBytes() {
        return this.addParamType("bytes");
    }

    public ContractFunctionSelector addBytesArray() {
        return this.addParamType("bytes[]");
    }

    public ContractFunctionSelector addBytes32() {
        return this.addParamType("bytes32");
    }

    public ContractFunctionSelector addBytes32Array() {
        return this.addParamType("bytes32[]");
    }

    public ContractFunctionSelector addBool() {
        return this.addParamType("bool");
    }

    public ContractFunctionSelector addInt8() {
        return this.addParamType("int8");
    }

    public ContractFunctionSelector addInt32() {
        return this.addParamType("int32");
    }

    public ContractFunctionSelector addInt64() {
        return this.addParamType("int64");
    }

    public ContractFunctionSelector addInt256() {
        return this.addParamType("int256");
    }

    public ContractFunctionSelector addInt8Array() {
        return this.addParamType("int8[]");
    }

    public ContractFunctionSelector addInt32Array() {
        return this.addParamType("int32[]");
    }

    public ContractFunctionSelector addInt64Array() {
        return this.addParamType("int64[]");
    }

    public ContractFunctionSelector addInt256Array() {
        return this.addParamType("int256[]");
    }

    public ContractFunctionSelector addAddress() {
        return this.addParamType("address");
    }

    public ContractFunctionSelector addAddressArray() {
        return this.addParamType("address[]");
    }

    public ContractFunctionSelector addFunction() {
        return this.addParamType("function");
    }

    ContractFunctionSelector addParamType(String typeName) {
        if (this.finished != null) {
            throw new IllegalStateException("FunctionSelector already finished");
        }
        Objects.requireNonNull(this.digest);
        if (this.needsComma) {
            this.digest.update((byte)44);
        }
        this.digest.update(typeName.getBytes(StandardCharsets.US_ASCII));
        this.needsComma = true;
        return this;
    }

    byte[] finish() {
        if (this.finished == null) {
            Objects.requireNonNull(this.digest);
            this.digest.update((byte)41);
            this.finished = Arrays.copyOf(this.digest.digest(), 4);
            this.digest = null;
        }
        return this.finished;
    }
}

