/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.contract;

import com.hedera.hashgraph.proto.ContractID;
import com.hedera.hashgraph.proto.ContractIDOrBuilder;
import com.hedera.hashgraph.proto.Key;
import com.hedera.hashgraph.proto.SignaturePair;
import com.hedera.hashgraph.sdk.IdUtil;
import com.hedera.hashgraph.sdk.Internal;
import com.hedera.hashgraph.sdk.SolidityUtil;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import java.util.Objects;

public final class ContractId
extends PublicKey {
    public final long shard;
    public final long realm;
    public final long contract;

    public ContractId(long shard, long realm, long contract) {
        this.shard = shard;
        this.realm = realm;
        this.contract = contract;
    }

    public ContractId(ContractIDOrBuilder contractID) {
        this(contractID.getShardNum(), contractID.getRealmNum(), contractID.getContractNum());
    }

    public static ContractId fromString(String account) throws IllegalArgumentException {
        return IdUtil.parseIdString(account, ContractId::new);
    }

    public static ContractId fromSolidityAddress(String address) {
        return SolidityUtil.parseAddress(address, ContractId::new);
    }

    @Override
    public Key toKeyProto() {
        return Key.newBuilder().setContractID(this.toProto()).build();
    }

    public int hashCode() {
        return Objects.hash(this.shard, this.realm, this.contract);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContractId)) {
            return false;
        }
        ContractId otherId = (ContractId)other;
        return this.shard == otherId.shard && this.realm == otherId.realm && this.contract == otherId.contract;
    }

    @Override
    public byte[] toBytes() {
        return this.toProto().toByteArray();
    }

    @Internal
    public ContractID toProto() {
        return ContractID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm).setContractNum(this.contract).build();
    }

    public String toString() {
        return "" + this.shard + "." + this.realm + "." + this.contract;
    }

    public String toSolidityAddress() {
        return SolidityUtil.addressFor(this);
    }

    @Override
    public SignaturePair.SignatureCase getSignatureCase() {
        throw new IllegalArgumentException("ContractId cannot be used with Transaction.signWith()");
    }
}

