/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.contract;

import com.hedera.hashgraph.proto.ContractGetInfoResponse;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.proto.TokenRelationship;
import com.hedera.hashgraph.sdk.DurationHelper;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.contract.ContractId;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import com.hedera.hashgraph.sdk.token.TokenId;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class ContractInfo {
    public final ContractId contractId;
    public final AccountId accountId;
    public final String contractAccountId;
    @Nullable
    public final PublicKey adminKey;
    public final Instant expirationTime;
    public final Duration autoRenewPeriod;
    public final long storage;
    @Nullable
    public final String contractMemo;
    public final Hbar balance;
    public final boolean isDeleted;
    public final Map<TokenId, com.hedera.hashgraph.sdk.account.TokenRelationship> tokenRelationships;

    ContractInfo(ContractGetInfoResponse.ContractInfoOrBuilder info) {
        if (!info.hasContractID()) {
            throw new IllegalArgumentException("info is empty");
        }
        this.contractId = new ContractId(info.getContractIDOrBuilder());
        this.accountId = new AccountId(info.getAccountIDOrBuilder());
        this.contractAccountId = info.getContractAccountID();
        this.adminKey = info.hasAdminKey() ? PublicKey.fromProtoKey(info.getAdminKey()) : null;
        this.expirationTime = TimestampHelper.timestampTo(info.getExpirationTime());
        this.autoRenewPeriod = DurationHelper.durationTo(info.getAutoRenewPeriod());
        this.storage = info.getStorage();
        String memo = info.getMemo();
        this.contractMemo = memo.isEmpty() ? null : memo;
        this.balance = Hbar.fromTinybar(info.getBalance());
        this.isDeleted = info.getDeleted();
        HashMap<TokenId, com.hedera.hashgraph.sdk.account.TokenRelationship> relationships = new HashMap<TokenId, com.hedera.hashgraph.sdk.account.TokenRelationship>(info.getTokenRelationshipsCount());
        for (TokenRelationship relationship : info.getTokenRelationshipsList()) {
            relationships.put(new TokenId(relationship.getTokenId()), new com.hedera.hashgraph.sdk.account.TokenRelationship(relationship));
        }
        this.tokenRelationships = relationships;
    }

    static ContractInfo fromResponse(Response response) {
        if (!response.hasContractGetInfo()) {
            throw new IllegalArgumentException("response was not `contractGetInfo`");
        }
        return new ContractInfo(response.getContractGetInfo().getContractInfo());
    }
}

