/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.contract;

import com.hedera.hashgraph.proto.ContractUpdateTransactionBody;
import com.hedera.hashgraph.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.DurationHelper;
import com.hedera.hashgraph.sdk.SingleTransactionBuilder;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.contract.ContractId;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import com.hedera.hashgraph.sdk.file.FileId;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.time.Instant;

public class ContractUpdateTransaction
extends SingleTransactionBuilder<ContractUpdateTransaction> {
    private final ContractUpdateTransactionBody.Builder builder;

    public ContractUpdateTransaction() {
        this.builder = this.bodyBuilder.getContractUpdateInstanceBuilder();
    }

    public ContractUpdateTransaction setContractId(ContractId contract) {
        this.builder.setContractID(contract.toProto());
        return this;
    }

    public ContractUpdateTransaction setExpirationTime(Instant expiration) {
        this.builder.setExpirationTime(TimestampHelper.timestampFrom(expiration));
        return this;
    }

    public ContractUpdateTransaction setAdminKey(PublicKey key) {
        this.builder.setAdminKey(key.toKeyProto());
        return this;
    }

    public ContractUpdateTransaction setProxyAccount(AccountId account) {
        this.builder.setProxyAccountID(account.toProto());
        return this;
    }

    public ContractUpdateTransaction setAutoRenewPeriod(Duration duration) {
        this.builder.setAutoRenewPeriod(DurationHelper.durationFrom(duration));
        return this;
    }

    public ContractUpdateTransaction setBytecodeFileId(FileId file) {
        this.builder.setFileID(file.toProto());
        return this;
    }

    public ContractUpdateTransaction setContractMemo(String memo) {
        this.builder.setMemo(memo);
        return this;
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return SmartContractServiceGrpc.getUpdateContractMethod();
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasContractID(), ".setContractId() required");
    }
}

