/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.crypto;

import com.hedera.hashgraph.proto.Key;
import com.hedera.hashgraph.proto.KeyList;
import com.hedera.hashgraph.proto.SignaturePair;
import com.hedera.hashgraph.sdk.crypto.PublicKey;

public class KeyList
extends PublicKey {
    private KeyList.Builder keyListBuilder = com.hedera.hashgraph.proto.KeyList.newBuilder();

    public KeyList add(PublicKey key) {
        this.keyListBuilder.addKeys(key.toKeyProto());
        return this;
    }

    public KeyList addAll(PublicKey ... keys) {
        for (PublicKey key : keys) {
            this.add(key);
        }
        return this;
    }

    @Override
    public byte[] toBytes() {
        return this.toKeyProto().toByteArray();
    }

    @Override
    public SignaturePair.SignatureCase getSignatureCase() {
        throw new IllegalArgumentException("KeyList cannot be used with Transaction.signWith()");
    }

    @Override
    public Key toKeyProto() {
        Key.Builder key = Key.newBuilder();
        key.setKeyList(this.keyListBuilder.build());
        return key.build();
    }
}

