/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.crypto;

import com.hedera.hashgraph.sdk.Internal;
import com.hedera.hashgraph.sdk.crypto.MnemonicValidationResult;
import com.hedera.hashgraph.sdk.crypto.MnemonicValidationStatus;
import com.hedera.hashgraph.sdk.crypto.ed25519.Ed25519PrivateKey;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;

public final class Mnemonic {
    public final List<CharSequence> words;
    @Nullable
    private String asString;
    private static final SecureRandom secureRandom = new SecureRandom();
    @Nullable
    private static SoftReference<List<String>> wordList;

    public Mnemonic(List<? extends CharSequence> words) {
        this.words = Collections.unmodifiableList(words);
    }

    public static Mnemonic fromString(String mnemonicString) {
        return new Mnemonic(Arrays.asList(mnemonicString.split(" ")));
    }

    public static Mnemonic generate() {
        byte[] entropy = new byte[32];
        secureRandom.nextBytes(entropy);
        return new Mnemonic(Mnemonic.entropyToWords(entropy));
    }

    public Ed25519PrivateKey toPrivateKey(String passphrase) {
        return Ed25519PrivateKey.fromMnemonic(this, passphrase);
    }

    public Ed25519PrivateKey toPrivateKey() {
        return this.toPrivateKey("");
    }

    public MnemonicValidationResult validate() {
        byte expectedChecksum;
        if (this.words.size() != 24) {
            return new MnemonicValidationResult(MnemonicValidationStatus.BadLength);
        }
        ArrayList<Integer> unknownIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.words.size(); ++i) {
            if (Mnemonic.getWordIndex(this.words.get(i)) >= 0) continue;
            unknownIndices.add(i);
        }
        if (!unknownIndices.isEmpty()) {
            return new MnemonicValidationResult(MnemonicValidationStatus.UnknownWords, unknownIndices);
        }
        byte[] entropyAndChecksum = this.wordsToEntropyAndChecksum();
        byte givenChecksum = entropyAndChecksum[32];
        if (givenChecksum != (expectedChecksum = Mnemonic.checksum(entropyAndChecksum))) {
            return new MnemonicValidationResult(MnemonicValidationStatus.ChecksumMismatch);
        }
        return new MnemonicValidationResult(MnemonicValidationStatus.Ok);
    }

    public String toString() {
        if (this.asString == null) {
            this.asString = String.join((CharSequence)" ", this.words);
        }
        return this.asString;
    }

    @Internal
    public byte[] toSeed(String passphrase) {
        String salt = "mnemonic" + passphrase;
        PKCS5S2ParametersGenerator pbkdf2 = new PKCS5S2ParametersGenerator((Digest)new SHA512Digest());
        pbkdf2.init(this.toString().getBytes(StandardCharsets.UTF_8), salt.getBytes(StandardCharsets.UTF_8), 2048);
        KeyParameter key = (KeyParameter)pbkdf2.generateDerivedParameters(512);
        return key.getKey();
    }

    private byte[] wordsToEntropyAndChecksum() {
        if (this.words.size() != 24) {
            throw new IllegalStateException("(BUG) expected 24-word mnemonic, got " + this.words.size() + " words");
        }
        ByteBuffer buffer = ByteBuffer.allocate(33);
        int scratch = 0;
        int offset = 0;
        for (CharSequence word : this.words) {
            int index = Mnemonic.getWordIndex(word);
            if (index < 0) {
                throw new IllegalStateException("(BUG) word not in word list: " + word);
            }
            if (index > 2047) {
                throw new IndexOutOfBoundsException("(BUG) index out of bounds: " + index);
            }
            scratch <<= 11;
            scratch |= index;
            offset += 11;
            while (offset >= 8) {
                buffer.put((byte)(scratch >> offset - 8));
                offset -= 8;
            }
        }
        return buffer.array();
    }

    private static List<String> entropyToWords(byte[] entropy) {
        if (entropy.length != 32) {
            throw new IllegalArgumentException("invalid entropy byte length: " + entropy.length);
        }
        byte[] bytes = Arrays.copyOf(entropy, 33);
        bytes[32] = Mnemonic.checksum(entropy);
        List<String> wordList = Mnemonic.getWordList();
        ArrayList<String> words = new ArrayList<String>(24);
        int scratch = 0;
        int offset = 0;
        for (byte b : bytes) {
            scratch <<= 8;
            scratch |= b & 0xFF;
            if ((offset += 8) < 11) continue;
            int index = scratch >> offset - 11 & 0x7FF;
            offset -= 11;
            words.add(wordList.get(index));
        }
        return words;
    }

    private static byte checksum(byte[] entropy) {
        SHA256Digest digest = new SHA256Digest();
        digest.update(entropy, 0, 32);
        byte[] checksum = new byte[digest.getDigestSize()];
        digest.doFinal(checksum, 0);
        return checksum[0];
    }

    private static int getWordIndex(CharSequence word) {
        return Collections.binarySearch(Mnemonic.getWordList(), word, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> getWordList() {
        if (wordList != null && wordList.get() != null) return wordList.get();
        Class<Mnemonic> clazz = Mnemonic.class;
        synchronized (Mnemonic.class) {
            if (wordList != null && wordList.get() != null) return wordList.get();
            List<String> words = Mnemonic.readWordList();
            wordList = new SoftReference<List<String>>(words);
            // ** MonitorExit[var0] (shouldn't be in output)
            return words;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> readWordList() {
        InputStream wordStream = Mnemonic.class.getClassLoader().getResourceAsStream("bip39-english.txt");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(wordStream)));){
            ArrayList<String> words = new ArrayList<String>(2048);
            String word = reader.readLine();
            while (word != null) {
                words.add(word);
                word = reader.readLine();
            }
            List<String> list = Collections.unmodifiableList(words);
            return list;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

