/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.crypto;

import com.hedera.hashgraph.proto.Key;
import com.hedera.hashgraph.proto.SignaturePair;
import com.hedera.hashgraph.proto.ThresholdKey;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import java.util.Collection;
import javax.annotation.Nonnegative;

public class ThresholdKey
extends PublicKey {
    private final ThresholdKey.Builder inner = com.hedera.hashgraph.proto.ThresholdKey.newBuilder();

    public ThresholdKey(@Nonnegative int threshold) {
        this.inner.setThreshold(threshold);
    }

    public ThresholdKey add(PublicKey key) {
        this.inner.getKeysBuilder().addKeys(key.toKeyProto());
        return this;
    }

    public ThresholdKey addAll(Collection<? extends PublicKey> keys) {
        for (PublicKey publicKey : keys) {
            this.add(publicKey);
        }
        return this;
    }

    public ThresholdKey addAll(PublicKey ... keys) {
        for (PublicKey key : keys) {
            this.add(key);
        }
        return this;
    }

    @Override
    public byte[] toBytes() {
        return this.toKeyProto().toByteArray();
    }

    @Override
    public Key toKeyProto() {
        if (this.inner.getKeysBuilder().getKeysCount() < this.inner.getThreshold()) {
            throw new IllegalStateException("ThresholdKey must have at least as many keys as the set threshold");
        }
        Key.Builder key = Key.newBuilder();
        key.setThresholdKey(this.inner);
        return key.build();
    }

    @Override
    public SignaturePair.SignatureCase getSignatureCase() {
        throw new IllegalArgumentException("TresholdKey cannot be used with Transaction.signWith()");
    }
}

