/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.crypto.ed25519;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.proto.Key;
import com.hedera.hashgraph.proto.SignaturePair;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import java.io.IOException;
import java.util.Arrays;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.util.encoders.Hex;

public final class Ed25519PublicKey
extends PublicKey {
    private final Ed25519PublicKeyParameters pubKeyParams;

    Ed25519PublicKey(Ed25519PublicKeyParameters pubKeyParams) {
        this.pubKeyParams = pubKeyParams;
    }

    public static Ed25519PublicKey fromBytes(byte[] bytes) {
        assert (bytes.length == 32);
        return new Ed25519PublicKey(new Ed25519PublicKeyParameters(bytes, 0));
    }

    public static Ed25519PublicKey fromString(String publicKeyString) {
        byte[] keyBytes = Hex.decode((String)publicKeyString);
        if (keyBytes.length == 32) {
            return Ed25519PublicKey.fromBytes(keyBytes);
        }
        SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyBytes);
        return Ed25519PublicKey.fromBytes(publicKeyInfo.getPublicKeyData().getBytes());
    }

    @Override
    public byte[] toBytes() {
        return this.pubKeyParams.getEncoded();
    }

    @Override
    public SignaturePair.SignatureCase getSignatureCase() {
        return SignaturePair.SignatureCase.ED25519;
    }

    public String toString() {
        byte[] encoded;
        SubjectPublicKeyInfo publicKeyInfo;
        try {
            publicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)this.pubKeyParams);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            encoded = publicKeyInfo.getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Hex.toHexString((byte[])encoded);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ed25519PublicKey that = (Ed25519PublicKey)o;
        return Arrays.equals(this.pubKeyParams.getEncoded(), that.pubKeyParams.getEncoded());
    }

    public int hashCode() {
        return Arrays.hashCode(this.pubKeyParams.getEncoded());
    }

    @Override
    public boolean hasPrefix(ByteString prefix) {
        return ByteString.copyFrom((byte[])this.toBytes()).startsWith(prefix);
    }

    @Override
    public Key toKeyProto() {
        return Key.newBuilder().setEd25519(ByteString.copyFrom((byte[])this.toBytes())).build();
    }
}

