/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.file;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.proto.FileAppendTransactionBody;
import com.hedera.hashgraph.proto.FileServiceGrpc;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.SingleTransactionBuilder;
import com.hedera.hashgraph.sdk.file.FileId;
import io.grpc.MethodDescriptor;

public final class FileAppendTransaction
extends SingleTransactionBuilder<FileAppendTransaction> {
    private final FileAppendTransactionBody.Builder builder;

    public FileAppendTransaction() {
        this.builder = this.bodyBuilder.getFileAppendBuilder();
    }

    public FileAppendTransaction setFileId(FileId fileId) {
        this.builder.setFileID(fileId.toProto());
        return this;
    }

    public FileAppendTransaction setContents(byte[] contents) {
        this.builder.setContents(ByteString.copyFrom((byte[])contents));
        return this;
    }

    public FileAppendTransaction setContents(String text) {
        this.builder.setContents(ByteString.copyFromUtf8((String)text));
        return this;
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return FileServiceGrpc.getAppendContentMethod();
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasFileID(), ".setFileId() required");
        this.require(this.builder.getContents(), ".setContents() required");
    }
}

