/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.file;

import com.hedera.hashgraph.proto.FileGetContentsQuery;
import com.hedera.hashgraph.proto.FileServiceGrpc;
import com.hedera.hashgraph.proto.Query;
import com.hedera.hashgraph.proto.QueryHeader;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.HederaNetworkException;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.QueryBuilder;
import com.hedera.hashgraph.sdk.file.FileId;
import io.grpc.MethodDescriptor;

public class FileContentsQuery
extends QueryBuilder<byte[], FileContentsQuery> {
    private final FileGetContentsQuery.Builder builder;

    public FileContentsQuery() {
        this.builder = this.inner.getFileGetContentsBuilder();
    }

    @Override
    protected QueryHeader.Builder getHeaderBuilder() {
        return this.builder.getHeaderBuilder();
    }

    public FileContentsQuery setFileId(FileId fileId) {
        this.builder.setFileID(fileId.toProto());
        return this;
    }

    @Override
    protected MethodDescriptor<Query, Response> getMethod() {
        return FileServiceGrpc.getGetFileContentMethod();
    }

    @Override
    public long getCost(Client client) throws HederaStatusException, HederaNetworkException {
        return Math.max(super.getCost(client), 50L);
    }

    @Override
    protected byte[] extractResponse(Response raw) {
        return raw.getFileGetContents().getFileContents().getContents().toByteArray();
    }

    @Override
    protected void doValidate() {
        this.require(this.builder.hasFileID(), ".setFileId() required");
    }
}

