/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.file;

import com.hedera.hashgraph.proto.FileID;
import com.hedera.hashgraph.proto.FileIDOrBuilder;
import com.hedera.hashgraph.sdk.IdUtil;
import com.hedera.hashgraph.sdk.Internal;
import com.hedera.hashgraph.sdk.SolidityUtil;
import java.util.Objects;

public final class FileId {
    public final long shard;
    public final long realm;
    public final long file;
    public static final FileId ADDRESS_BOOK = new FileId(0L, 0L, 102L);
    public static final FileId FEE_SCHEDULE = new FileId(0L, 0L, 111L);
    public static final FileId EXCHANGE_RATES = new FileId(0L, 0L, 112L);

    public FileId(long shardNum, long realmNum, long fileNum) {
        this.shard = shardNum;
        this.realm = realmNum;
        this.file = fileNum;
    }

    public FileId(FileIDOrBuilder fileId) {
        this(fileId.getShardNum(), fileId.getRealmNum(), fileId.getFileNum());
    }

    public static FileId fromString(String account) throws IllegalArgumentException {
        return IdUtil.parseIdString(account, FileId::new);
    }

    @Deprecated
    public static FileId fromSolidityAddress(String address) {
        return SolidityUtil.parseAddress(address, FileId::new);
    }

    public int hashCode() {
        return Objects.hash(this.shard, this.realm, this.file);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileId)) {
            return false;
        }
        FileId otherId = (FileId)other;
        return this.shard == otherId.shard && this.realm == otherId.realm && this.file == otherId.file;
    }

    @Internal
    public FileID toProto() {
        return FileID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm).setFileNum(this.file).build();
    }

    public String toString() {
        return "" + this.shard + "." + this.realm + "." + this.file;
    }

    @Deprecated
    public String toSolidityAddress() {
        return SolidityUtil.addressFor(this);
    }
}

