/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.token;

import com.hedera.hashgraph.proto.TokenID;
import com.hedera.hashgraph.proto.TokenIDOrBuilder;
import com.hedera.hashgraph.sdk.IdUtil;
import com.hedera.hashgraph.sdk.Internal;
import com.hedera.hashgraph.sdk.SolidityUtil;
import java.util.Objects;

public final class TokenId {
    public final long shard;
    public final long realm;
    public final long token;

    public TokenId(long tokenNum) {
        this(0L, 0L, tokenNum);
    }

    public TokenId(long shard, long realm, long token) {
        this.shard = shard;
        this.realm = realm;
        this.token = token;
    }

    public static TokenId fromString(String token) throws IllegalArgumentException {
        return IdUtil.parseIdString(token, TokenId::new);
    }

    public TokenId(TokenIDOrBuilder tokenId) {
        this(tokenId.getShardNum(), tokenId.getRealmNum(), tokenId.getTokenNum());
    }

    public static TokenId fromSolidityAddress(String address) {
        return SolidityUtil.parseAddress(address, TokenId::new);
    }

    public String toString() {
        return "" + this.shard + "." + this.realm + "." + this.token;
    }

    public String toSolidityAddress() {
        return SolidityUtil.addressFor(this);
    }

    @Internal
    public TokenID toProto() {
        return TokenID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm).setTokenNum(this.token).build();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TokenId otherId = (TokenId)other;
        return otherId.token == this.token && otherId.realm == this.realm && otherId.shard == this.shard;
    }

    public int hashCode() {
        return Objects.hash(this.token, this.realm, this.shard);
    }
}

