/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.token;

import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.proto.TokenFreezeStatus;
import com.hedera.hashgraph.proto.TokenGetInfoResponse;
import com.hedera.hashgraph.proto.TokenKycStatus;
import com.hedera.hashgraph.sdk.DurationHelper;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import com.hedera.hashgraph.sdk.crypto.ed25519.Ed25519PublicKey;
import com.hedera.hashgraph.sdk.token.TokenId;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;

public class TokenInfo {
    public final TokenId tokenId;
    public final String name;
    public final String symbol;
    public final int decimals;
    public final long totalSupply;
    public final AccountId treasury;
    @Nullable
    public final PublicKey adminKey;
    @Nullable
    public final PublicKey kycKey;
    @Nullable
    public final PublicKey freezeKey;
    @Nullable
    public final PublicKey wipeKey;
    @Nullable
    public final PublicKey supplyKey;
    @Nullable
    public final Boolean defaultFreezeStatus;
    @Nullable
    public final Boolean defaultKycStatus;
    public final boolean isDeleted;
    @Nullable
    public final AccountId autoRenewAccount;
    public final Duration autoRenewPeriod;
    public final Instant expiry;

    TokenInfo(com.hedera.hashgraph.proto.TokenInfo info) {
        TokenFreezeStatus defaultFreezeStatus = info.getDefaultFreezeStatus();
        TokenKycStatus defaultKycStatus = info.getDefaultKycStatus();
        this.tokenId = new TokenId(info.getTokenIdOrBuilder());
        this.name = info.getName();
        this.symbol = info.getSymbol();
        this.decimals = info.getDecimals();
        this.totalSupply = info.getTotalSupply();
        this.treasury = new AccountId(info.getTreasuryOrBuilder());
        this.adminKey = info.hasAdminKey() ? Ed25519PublicKey.fromProtoKey(info.getAdminKeyOrBuilder()) : null;
        this.kycKey = info.hasKycKey() ? Ed25519PublicKey.fromProtoKey(info.getKycKeyOrBuilder()) : null;
        this.freezeKey = info.hasFreezeKey() ? Ed25519PublicKey.fromProtoKey(info.getFreezeKeyOrBuilder()) : null;
        this.wipeKey = info.hasWipeKey() ? Ed25519PublicKey.fromProtoKey(info.getWipeKeyOrBuilder()) : null;
        PublicKey publicKey = this.supplyKey = info.hasSupplyKey() ? Ed25519PublicKey.fromProtoKey(info.getSupplyKeyOrBuilder()) : null;
        Boolean bl = defaultFreezeStatus == TokenFreezeStatus.FreezeNotApplicable ? null : (this.defaultFreezeStatus = Boolean.valueOf(defaultFreezeStatus == TokenFreezeStatus.Frozen));
        this.defaultKycStatus = defaultKycStatus == TokenKycStatus.KycNotApplicable ? null : Boolean.valueOf(defaultKycStatus == TokenKycStatus.Granted);
        this.isDeleted = info.getDeleted();
        this.autoRenewAccount = info.hasAutoRenewAccount() ? new AccountId(info.getAutoRenewAccountOrBuilder()) : null;
        this.autoRenewPeriod = DurationHelper.durationTo(info.getAutoRenewPeriod());
        this.expiry = TimestampHelper.timestampTo(info.getExpiry());
    }

    static TokenInfo fromResponse(Response response) {
        if (!response.hasTokenGetInfo()) {
            throw new IllegalArgumentException("query response was not `TokenGetInfoResponse`");
        }
        TokenGetInfoResponse infoResponse = response.getTokenGetInfo();
        return new TokenInfo(infoResponse.getTokenInfo());
    }
}

