/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk.token;

import com.hedera.hashgraph.proto.TokenServiceGrpc;
import com.hedera.hashgraph.proto.TokenUpdateTransactionBody;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.DurationHelper;
import com.hedera.hashgraph.sdk.SingleTransactionBuilder;
import com.hedera.hashgraph.sdk.TimestampHelper;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import com.hedera.hashgraph.sdk.token.TokenId;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.time.Instant;

public final class TokenUpdateTransaction
extends SingleTransactionBuilder<TokenUpdateTransaction> {
    private final TokenUpdateTransactionBody.Builder builder;

    public TokenUpdateTransaction() {
        this.builder = this.bodyBuilder.getTokenUpdateBuilder();
    }

    public TokenUpdateTransaction setTokenId(TokenId tokenId) {
        this.builder.setToken(tokenId.toProto());
        return this;
    }

    public TokenUpdateTransaction setName(String name) {
        this.builder.setName(name);
        return this;
    }

    public TokenUpdateTransaction setSymbol(String symbol) {
        this.builder.setSymbol(symbol);
        return this;
    }

    public TokenUpdateTransaction setTreasury(AccountId treasury) {
        this.builder.setTreasury(treasury.toProto());
        return this;
    }

    public TokenUpdateTransaction setAdminKey(PublicKey key) {
        this.builder.setAdminKey(key.toKeyProto());
        return this;
    }

    public TokenUpdateTransaction setKycKey(PublicKey key) {
        this.builder.setKycKey(key.toKeyProto());
        return this;
    }

    public TokenUpdateTransaction setFreezeKey(PublicKey key) {
        this.builder.setFreezeKey(key.toKeyProto());
        return this;
    }

    public TokenUpdateTransaction setWipeKey(PublicKey key) {
        this.builder.setWipeKey(key.toKeyProto());
        return this;
    }

    public TokenUpdateTransaction setSupplyKey(PublicKey key) {
        this.builder.setSupplyKey(key.toKeyProto());
        return this;
    }

    public TokenUpdateTransaction setExpirationTime(Instant expirationTime) {
        this.builder.setExpiry(TimestampHelper.timestampFrom(expirationTime));
        return this;
    }

    public TokenUpdateTransaction setAutoRenewAccount(AccountId account) {
        this.builder.setAutoRenewAccount(account.toProto());
        return this;
    }

    public TokenUpdateTransaction setAutoRenewPeriod(Duration period) {
        this.builder.setAutoRenewPeriod(DurationHelper.durationFrom(period));
        return this;
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return TokenServiceGrpc.getUpdateTokenMethod();
    }

    @Override
    protected void doValidate() {
    }
}

