/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.proto.CryptoGetAccountBalanceResponse;
import com.hedera.hashgraph.sdk.proto.TokenBalance;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;

public class AccountBalance {
    @Nonnegative
    public final Hbar hbars;
    @Nonnegative
    public final Map<TokenId, Long> token;

    AccountBalance(Hbar hbars, Map<TokenId, Long> token) {
        this.hbars = hbars;
        this.token = token;
    }

    static AccountBalance fromProtobuf(CryptoGetAccountBalanceResponse protobuf) {
        List<TokenBalance> balanceList = protobuf.getTokenBalancesList();
        HashMap<TokenId, Long> map = new HashMap<TokenId, Long>();
        for (int i = 0; i < protobuf.getTokenBalancesCount(); ++i) {
            map.put(TokenId.fromProtobuf(balanceList.get(i).getTokenId()), balanceList.get(i).getBalance());
        }
        return new AccountBalance(Hbar.fromTinybars(protobuf.getBalance()), map);
    }

    static AccountBalance fromBytes(byte[] data) throws InvalidProtocolBufferException {
        return AccountBalance.fromProtobuf(CryptoGetAccountBalanceResponse.parseFrom(data));
    }

    CryptoGetAccountBalanceResponse toProtobuf() {
        CryptoGetAccountBalanceResponse.Builder protobuf = CryptoGetAccountBalanceResponse.newBuilder().setBalance(this.hbars.toTinybars());
        for (Map.Entry<TokenId, Long> entry : this.token.entrySet()) {
            protobuf.addTokenBalances(TokenBalance.newBuilder().setBalance(entry.getValue()).setTokenId(entry.getKey().toProtobuf()));
        }
        return (CryptoGetAccountBalanceResponse)protobuf.build();
    }

    ByteString toBytes() {
        return this.toProtobuf().toByteString();
    }
}

