/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.CryptoCreateTransactionBody;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class AccountCreateTransaction
extends com.hedera.hashgraph.sdk.Transaction<AccountCreateTransaction> {
    private static final Hbar DEFAULT_RECORD_THRESHOLD = Hbar.fromTinybars(Long.MAX_VALUE);
    private final CryptoCreateTransactionBody.Builder builder;

    public AccountCreateTransaction() {
        this.builder = CryptoCreateTransactionBody.newBuilder();
        this.setAutoRenewPeriod(DEFAULT_AUTO_RENEW_PERIOD);
        this.setSendRecordThreshold(DEFAULT_RECORD_THRESHOLD);
        this.setReceiveRecordThreshold(DEFAULT_RECORD_THRESHOLD);
    }

    AccountCreateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (CryptoCreateTransactionBody.Builder)this.bodyBuilder.getCryptoCreateAccount().toBuilder();
    }

    @Nullable
    public Key getKey() {
        return this.builder.hasKey() ? Key.fromProtobufKey(this.builder.getKey()) : null;
    }

    public AccountCreateTransaction setKey(Key key) {
        this.requireNotFrozen();
        this.builder.setKey(key.toProtobufKey());
        return this;
    }

    public Hbar getInitialBalance() {
        return Hbar.fromTinybars(this.builder.getInitialBalance());
    }

    public AccountCreateTransaction setInitialBalance(Hbar initialBalance) {
        this.requireNotFrozen();
        this.builder.setInitialBalance(initialBalance.toTinybars());
        return this;
    }

    Hbar getSendRecordThreshold() {
        return Hbar.fromTinybars(this.builder.getSendRecordThreshold());
    }

    AccountCreateTransaction setSendRecordThreshold(Hbar sendRecordThreshold) {
        this.requireNotFrozen();
        this.builder.setSendRecordThreshold(sendRecordThreshold.toTinybars());
        return this;
    }

    Hbar getReceiveRecordThreshold() {
        return Hbar.fromTinybars(this.builder.getReceiveRecordThreshold());
    }

    AccountCreateTransaction setReceiveRecordThreshold(Hbar receiveRecordThreshold) {
        this.requireNotFrozen();
        this.builder.setReceiveRecordThreshold(receiveRecordThreshold.toTinybars());
        return this;
    }

    public boolean getReceiverSignatureRequired() {
        return this.builder.getReceiverSigRequired();
    }

    public AccountCreateTransaction setReceiverSignatureRequired(boolean receiveSignatureRequired) {
        this.requireNotFrozen();
        this.builder.setReceiverSigRequired(receiveSignatureRequired);
        return this;
    }

    @Nullable
    public AccountId getProxyAccountId() {
        return this.builder.hasProxyAccountID() ? AccountId.fromProtobuf(this.builder.getProxyAccountID()) : null;
    }

    public AccountCreateTransaction setProxyAccountId(AccountId proxyAccountId) {
        this.requireNotFrozen();
        this.builder.setProxyAccountID(proxyAccountId.toProtobuf());
        return this;
    }

    @Nullable
    public Duration getAutoRenewPeriod() {
        return this.builder.hasAutoRenewPeriod() ? DurationConverter.fromProtobuf(this.builder.getAutoRenewPeriod()) : null;
    }

    public AccountCreateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        this.requireNotFrozen();
        this.builder.setAutoRenewPeriod(DurationConverter.toProtobuf(autoRenewPeriod));
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return CryptoServiceGrpc.getCreateAccountMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setCryptoCreateAccount(this.builder);
        return true;
    }
}

