/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.ProxyStaker;
import com.hedera.hashgraph.sdk.Query;
import com.hedera.hashgraph.sdk.proto.AllProxyStakers;
import com.hedera.hashgraph.sdk.proto.CryptoGetStakersQuery;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Query;
import com.hedera.hashgraph.sdk.proto.QueryHeader;
import com.hedera.hashgraph.sdk.proto.Response;
import com.hedera.hashgraph.sdk.proto.ResponseHeader;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.List;

public final class AccountStakersQuery
extends Query<List<ProxyStaker>, AccountStakersQuery> {
    private final CryptoGetStakersQuery.Builder builder = CryptoGetStakersQuery.newBuilder();

    public AccountId getAccountId() {
        return AccountId.fromProtobuf(this.builder.getAccountID());
    }

    public AccountStakersQuery setAccountId(AccountId accountId) {
        this.builder.setAccountID(accountId.toProtobuf());
        return this;
    }

    @Override
    void onMakeRequest(Query.Builder queryBuilder, QueryHeader header) {
        queryBuilder.setCryptoGetProxyStakers(this.builder.setHeader(header));
    }

    @Override
    ResponseHeader mapResponseHeader(Response response) {
        return response.getCryptoGetProxyStakers().getHeader();
    }

    @Override
    QueryHeader mapRequestHeader(com.hedera.hashgraph.sdk.proto.Query request) {
        return request.getCryptoGetProxyStakers().getHeader();
    }

    @Override
    List<ProxyStaker> mapResponse(Response response, AccountId nodeId, com.hedera.hashgraph.sdk.proto.Query request) {
        AllProxyStakers rawStakers = response.getCryptoGetProxyStakers().getStakers();
        ArrayList<ProxyStaker> stakers = new ArrayList<ProxyStaker>(rawStakers.getProxyStakerCount());
        for (int i = 0; i < rawStakers.getProxyStakerCount(); ++i) {
            stakers.add(ProxyStaker.fromProtobuf(rawStakers.getProxyStaker(i)));
        }
        return stakers;
    }

    @Override
    MethodDescriptor<com.hedera.hashgraph.sdk.proto.Query, Response> getMethodDescriptor() {
        return CryptoServiceGrpc.getGetStakersByAccountIDMethod();
    }
}

