/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionResponse;
import com.hedera.hashgraph.sdk.WithExecuteAll;
import com.hedera.hashgraph.sdk.proto.SignatureMap;
import com.hedera.hashgraph.sdk.proto.SignedTransaction;
import com.hedera.hashgraph.sdk.proto.Timestamp;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.Nullable;

abstract class ChunkedTransaction<T extends ChunkedTransaction<T>>
extends com.hedera.hashgraph.sdk.Transaction<T>
implements WithExecuteAll {
    private static final int CHUNK_SIZE = 4096;
    private int maxChunks = 10;
    protected ByteString data = ByteString.EMPTY;

    ChunkedTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
    }

    ChunkedTransaction() {
    }

    @Nullable
    ByteString getData() {
        return this.data;
    }

    T setData(byte[] data) {
        this.requireNotFrozen();
        this.data = ByteString.copyFrom((byte[])data);
        return (T)this;
    }

    T setData(ByteString data) {
        this.requireNotFrozen();
        this.data = data;
        return (T)this;
    }

    T setData(String text) {
        this.requireNotFrozen();
        this.data = ByteString.copyFromUtf8((String)text);
        return (T)this;
    }

    public T setMaxChunks(int maxChunks) {
        this.requireNotFrozen();
        this.maxChunks = maxChunks;
        return (T)this;
    }

    public int getMaxChunks() {
        return this.maxChunks;
    }

    @Override
    public byte[] getTransactionHash() {
        if (this.transactions.size() > this.nodeAccountIds.size()) {
            throw new IllegalStateException("a single transaction hash can not be calculated for a chunked transaction, try calling `getAllTransactionHashesPerNode`");
        }
        return super.getTransactionHash();
    }

    @Override
    public Map<AccountId, byte[]> getTransactionHashPerNode() {
        if (this.transactions.size() > this.nodeAccountIds.size()) {
            throw new IllegalStateException("a single transaction hash can not be calculated for a chunked transaction, try calling `getAllTransactionHashesPerNode`");
        }
        return super.getTransactionHashPerNode();
    }

    public final List<Map<AccountId, byte[]>> getAllTransactionHashesPerNode() {
        if (!this.isFrozen()) {
            throw new IllegalStateException("transaction must have been frozen before calculating the hash will be stable, try calling `freeze`");
        }
        int size = this.signedTransactions.size() / this.nodeAccountIds.size();
        ArrayList<Map<AccountId, byte[]>> transactionHashes = new ArrayList<Map<AccountId, byte[]>>(this.transactions.size() / this.nodeAccountIds.size());
        for (int group = 0; group < size; ++group) {
            HashMap<AccountId, byte[]> hashes = new HashMap<AccountId, byte[]>();
            for (int i = group * size; i < (group + 1) * size; ++i) {
                hashes.put((AccountId)this.nodeAccountIds.get(group), ChunkedTransaction.hash(((Transaction)this.transactions.get(i)).getSignedTransactionBytes().toByteArray()));
            }
            transactionHashes.add(hashes);
        }
        return transactionHashes;
    }

    @Override
    public CompletableFuture<List<TransactionResponse>> executeAllAsync(Client client) {
        AccountId operatorId;
        if (!this.isFrozen()) {
            this.freezeWith(client);
        }
        if ((operatorId = client.getOperatorAccountId()) != null && operatorId.equals(Objects.requireNonNull(this.getTransactionId()).accountId)) {
            this.signWithOperator(client);
        }
        CompletionStage<List<TransactionResponse>> future = CompletableFuture.supplyAsync(() -> new ArrayList(this.transactionIds.size()));
        for (int i = 0; i < this.transactionIds.size(); ++i) {
            future = future.thenCompose(list -> {
                CompletableFuture responseFuture = super.executeAsync(client);
                Function<TransactionResponse, CompletionStage> receiptFuture = response -> response.getReceiptAsync(client).thenApply(receipt -> response);
                Function<TransactionResponse, List> addToList = response -> {
                    list.add(response);
                    return list;
                };
                if (this.shouldGetReceipt()) {
                    return ((CompletableFuture)((CompletableFuture)responseFuture.thenCompose(receiptFuture)).thenApply(addToList)).thenCompose(CompletableFuture::completedFuture);
                }
                return ((CompletableFuture)responseFuture.thenApply(addToList)).thenCompose(CompletableFuture::completedFuture);
            });
        }
        return future;
    }

    @Override
    public CompletableFuture<TransactionResponse> executeAsync(Client client) {
        return this.executeAllAsync(client).thenApply(responses -> (TransactionResponse)responses.get(0));
    }

    @Override
    public T freezeWith(@Nullable Client client) {
        super.freezeWith(client);
        TransactionID initialTransactionId = Objects.requireNonNull((TransactionId)this.transactionIds.get(0)).toProtobuf();
        int requiredChunks = (this.data.size() + 4095) / 4096;
        if (requiredChunks == 0) {
            requiredChunks = 1;
        }
        if (requiredChunks > this.maxChunks) {
            throw new IllegalArgumentException("message of " + this.data.size() + " bytes requires " + requiredChunks + " chunks but the maximum allowed chunks is " + this.maxChunks + ", try using setMaxChunks");
        }
        this.signatures = new ArrayList(requiredChunks * this.nodeAccountIds.size());
        this.transactions = new ArrayList(requiredChunks * this.nodeAccountIds.size());
        this.signedTransactions = new ArrayList(requiredChunks * this.nodeAccountIds.size());
        this.transactionIds = new ArrayList(requiredChunks);
        TransactionID.Builder nextTransactionId = (TransactionID.Builder)initialTransactionId.toBuilder();
        for (int i = 0; i < requiredChunks; ++i) {
            int startIndex = i * 4096;
            int endIndex = startIndex + 4096;
            if (endIndex > this.data.size()) {
                endIndex = this.data.size();
            }
            this.transactionIds.add(TransactionId.fromProtobuf((TransactionID)nextTransactionId.build()));
            this.onFreezeChunk(this.bodyBuilder.setTransactionID((TransactionID)nextTransactionId.build()), initialTransactionId, startIndex, endIndex, i, requiredChunks);
            for (AccountId nodeId : this.nodeAccountIds) {
                this.signatures.add(SignatureMap.newBuilder());
                this.signedTransactions.add(SignedTransaction.newBuilder().setBodyBytes(((TransactionBody)this.bodyBuilder.setNodeAccountID(nodeId.toProtobuf()).build()).toByteString()));
            }
            Timestamp.Builder nextValidStart = (Timestamp.Builder)nextTransactionId.getTransactionValidStart().toBuilder();
            nextValidStart.setNanos(nextValidStart.getNanos() + 1);
            nextTransactionId.setTransactionValidStart(nextValidStart);
        }
        return (T)this;
    }

    abstract void onFreezeChunk(TransactionBody.Builder var1, TransactionID var2, int var3, int var4, int var5, int var6);

    boolean shouldGetReceipt() {
        return false;
    }
}

