/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ContractFunctionParameters;
import com.hedera.hashgraph.sdk.ContractFunctionResult;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.Query;
import com.hedera.hashgraph.sdk.proto.ContractCallLocalQuery;
import com.hedera.hashgraph.sdk.proto.Query;
import com.hedera.hashgraph.sdk.proto.QueryHeader;
import com.hedera.hashgraph.sdk.proto.Response;
import com.hedera.hashgraph.sdk.proto.ResponseHeader;
import com.hedera.hashgraph.sdk.proto.SmartContractServiceGrpc;
import io.grpc.MethodDescriptor;
import java.util.concurrent.CompletableFuture;

public final class ContractCallQuery
extends Query<ContractFunctionResult, ContractCallQuery> {
    private final ContractCallLocalQuery.Builder builder = ContractCallLocalQuery.newBuilder();

    public ContractId getContractId() {
        return ContractId.fromProtobuf(this.builder.getContractID());
    }

    public ContractCallQuery setContractId(ContractId contractId) {
        this.builder.setContractID(contractId.toProtobuf());
        return this;
    }

    public long getGas() {
        return this.builder.getGas();
    }

    public ContractCallQuery setGas(long gas) {
        this.builder.setGas(gas);
        return this;
    }

    @Override
    public CompletableFuture<Hbar> getCostAsync(Client client) {
        return super.getCostAsync(client).thenApply(cost -> Hbar.fromTinybars((long)((double)cost.toTinybars() * 1.1)));
    }

    public ByteString getFunctionParameters() {
        return this.builder.getFunctionParameters();
    }

    public ContractCallQuery setFunctionParameters(byte[] functionParameters) {
        this.builder.setFunctionParameters(ByteString.copyFrom((byte[])functionParameters));
        return this;
    }

    public ContractCallQuery setFunction(String name) {
        return this.setFunction(name, new ContractFunctionParameters());
    }

    public ContractCallQuery setFunction(String name, ContractFunctionParameters params) {
        this.builder.setFunctionParameters(params.toBytes(name));
        return this;
    }

    public ContractCallQuery setMaxResultSize(long size) {
        this.builder.setMaxResultSize(size);
        return this;
    }

    @Override
    void onMakeRequest(Query.Builder queryBuilder, QueryHeader header) {
        queryBuilder.setContractCallLocal(this.builder.setHeader(header));
    }

    @Override
    ResponseHeader mapResponseHeader(Response response) {
        return response.getContractCallLocal().getHeader();
    }

    @Override
    QueryHeader mapRequestHeader(com.hedera.hashgraph.sdk.proto.Query request) {
        return request.getContractCallLocal().getHeader();
    }

    @Override
    ContractFunctionResult mapResponse(Response response, AccountId nodeId, com.hedera.hashgraph.sdk.proto.Query request) {
        return new ContractFunctionResult(response.getContractCallLocal().getFunctionResult());
    }

    @Override
    MethodDescriptor<com.hedera.hashgraph.sdk.proto.Query, Response> getMethodDescriptor() {
        return SmartContractServiceGrpc.getContractCallLocalMethodMethod();
    }
}

