/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.ContractFunctionParameters;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ContractCallTransactionBody;
import com.hedera.hashgraph.sdk.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class ContractExecuteTransaction
extends com.hedera.hashgraph.sdk.Transaction<ContractExecuteTransaction> {
    private final ContractCallTransactionBody.Builder builder;

    public ContractExecuteTransaction() {
        this.builder = ContractCallTransactionBody.newBuilder();
    }

    ContractExecuteTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (ContractCallTransactionBody.Builder)this.bodyBuilder.getContractCall().toBuilder();
    }

    @Nullable
    public ContractId getContractId() {
        return this.builder.hasContractID() ? ContractId.fromProtobuf(this.builder.getContractID()) : null;
    }

    public ContractExecuteTransaction setContractId(ContractId contractId) {
        this.requireNotFrozen();
        this.builder.setContractID(contractId.toProtobuf());
        return this;
    }

    public long getGas() {
        return this.builder.getGas();
    }

    public ContractExecuteTransaction setGas(long gas) {
        this.requireNotFrozen();
        this.builder.setGas(gas);
        return this;
    }

    public Hbar getPayableAmount() {
        return Hbar.fromTinybars(this.builder.getAmount());
    }

    public ContractExecuteTransaction setPayableAmount(Hbar amount) {
        this.requireNotFrozen();
        this.builder.setAmount(amount.toTinybars());
        return this;
    }

    public ByteString getFunctionParameters() {
        return this.builder.getFunctionParameters();
    }

    public ContractExecuteTransaction setFunctionParameters(ByteString functionParameters) {
        this.requireNotFrozen();
        this.builder.setFunctionParameters(functionParameters);
        return this;
    }

    public ContractExecuteTransaction setFunction(String name) {
        return this.setFunction(name, new ContractFunctionParameters());
    }

    public ContractExecuteTransaction setFunction(String name, ContractFunctionParameters params) {
        return this.setFunctionParameters(params.toBytes(name));
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return SmartContractServiceGrpc.getContractCallMethodMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setContractCall(this.builder);
        return true;
    }
}

