/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.ThreadLocalSecureRandom;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

final class Crypto {
    static final int IV_LEN = 16;
    static final int ITERATIONS = 262144;
    static final int SALT_LEN = 32;
    static final int DK_LEN = 32;
    static final int CBC_DK_LEN = 16;

    private Crypto() {
    }

    static KeyParameter deriveKeySha256(String passphrase, byte[] salt, int iterations, int dkLenBytes) {
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator((Digest)new SHA256Digest());
        gen.init(passphrase.getBytes(StandardCharsets.UTF_8), salt, iterations);
        return (KeyParameter)gen.generateDerivedParameters(dkLenBytes * 8);
    }

    static Cipher initAesCtr128(KeyParameter cipherKey, byte[] iv, boolean forDecrypt) {
        Cipher aesCipher;
        try {
            aesCipher = Cipher.getInstance("AES/CTR/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new Error("platform does not support AES-CTR ciphers", e);
        }
        return Crypto.initAesCipher(aesCipher, cipherKey, iv, forDecrypt);
    }

    static Cipher initAesCbc128Encrypt(KeyParameter cipherKey, byte[] iv) {
        Cipher aesCipher;
        try {
            aesCipher = Cipher.getInstance("AES/CBC/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new Error("platform does not support AES-CBC ciphers", e);
        }
        return Crypto.initAesCipher(aesCipher, cipherKey, iv, false);
    }

    static Cipher initAesCbc128Decrypt(KeyParameter cipherKey, AlgorithmParameters parameters) {
        Cipher aesCipher;
        try {
            aesCipher = Cipher.getInstance("AES/CBC/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new Error("platform does not support AES-CBC ciphers", e);
        }
        try {
            aesCipher.init(2, (Key)new SecretKeySpec(cipherKey.getKey(), 0, 16, "AES"), parameters);
        }
        catch (InvalidKeyException e) {
            throw new Error("platform does not support AES-128 ciphers", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new Error(e);
        }
        return aesCipher;
    }

    private static Cipher initAesCipher(Cipher aesCipher, KeyParameter cipherKey, byte[] iv, boolean forDecrypt) {
        int mode = forDecrypt ? 2 : 1;
        try {
            aesCipher.init(mode, (Key)new SecretKeySpec(cipherKey.getKey(), 0, 16, "AES"), new IvParameterSpec(iv));
        }
        catch (InvalidKeyException e) {
            throw new Error("platform does not support AES-128 ciphers", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new Error(e);
        }
        return aesCipher;
    }

    static byte[] encryptAesCtr128(KeyParameter cipherKey, byte[] iv, byte[] input) {
        Cipher aesCipher = Crypto.initAesCtr128(cipherKey, iv, false);
        return Crypto.runCipher(aesCipher, input);
    }

    static byte[] decryptAesCtr128(KeyParameter cipherKey, byte[] iv, byte[] input) {
        Cipher aesCipher = Crypto.initAesCtr128(cipherKey, iv, true);
        return Crypto.runCipher(aesCipher, input);
    }

    static byte[] runCipher(Cipher cipher, byte[] input) {
        byte[] output = new byte[cipher.getOutputSize(input.length)];
        try {
            cipher.doFinal(input, 0, input.length, output);
        }
        catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            throw new Error(e);
        }
        return output;
    }

    static byte[] calcHmacSha384(KeyParameter cipherKey, byte[] input) {
        HMac hmacSha384 = new HMac((Digest)new SHA384Digest());
        byte[] output = new byte[hmacSha384.getMacSize()];
        hmacSha384.init((CipherParameters)new KeyParameter(cipherKey.getKey(), 16, 16));
        hmacSha384.update(input, 0, input.length);
        hmacSha384.doFinal(output, 0);
        return output;
    }

    static byte[] randomBytes(int len) {
        byte[] out = new byte[len];
        ThreadLocalSecureRandom.current().nextBytes(out);
        return out;
    }
}

