/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.Splitter;
import com.google.errorprone.annotations.Var;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;

class EntityIdHelper {
    static final int SOLIDITY_ADDRESS_LEN = 20;
    static final int SOLIDITY_ADDRESS_LEN_HEX = 40;

    EntityIdHelper() {
    }

    static <R> R fromString(String id, WithIdNums<R> withIdNums) {
        R newId;
        Iterator nums = Splitter.on((char)'.').split((CharSequence)id).iterator();
        try {
            long shard = Long.parseLong((String)nums.next());
            long realm = Long.parseLong((String)nums.next());
            long num = Long.parseLong((String)nums.next());
            newId = withIdNums.apply(shard, realm, num);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid Id format, should be in format {shardNum}.{realmNum}.{idNum}", e);
        }
        return newId;
    }

    static <R> R fromSolidityAddress(String address, WithIdNums<R> withAddress) {
        return EntityIdHelper.fromSolidityAddress(EntityIdHelper.decodeSolidityAddress(address), withAddress);
    }

    private static <R> R fromSolidityAddress(byte[] address, WithIdNums<R> withAddress) {
        if (address.length != 20) {
            throw new IllegalArgumentException("Solidity addresses must be 20 bytes or 40 hex chars");
        }
        ByteBuffer buf = ByteBuffer.wrap(address);
        return withAddress.apply(buf.getInt(), buf.getLong(), buf.getLong());
    }

    private static byte[] decodeSolidityAddress(@Var String address) {
        String string = address = address.startsWith("0x") ? address.substring(2) : address;
        if (address.length() != 40) {
            throw new IllegalArgumentException("Solidity addresses must be 20 bytes or 40 hex chars");
        }
        try {
            return Hex.decode((String)address);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("failed to decode Solidity address as hex", e);
        }
    }

    static String toSolidityAddress(long shard, long realm, long num) {
        if (Long.highestOneBit(shard) > 32L) {
            throw new IllegalStateException("shard out of 32-bit range " + shard);
        }
        return Hex.toHexString((byte[])ByteBuffer.allocate(20).putInt((int)shard).putLong(realm).putLong(num).array());
    }

    @FunctionalInterface
    static interface WithIdNums<R> {
        public R apply(long var1, long var3, long var5);
    }
}

