/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.ChunkedTransaction;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.FileAppendTransactionBody;
import com.hedera.hashgraph.sdk.proto.FileServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SignedTransaction;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionID;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class FileAppendTransaction
extends ChunkedTransaction<FileAppendTransaction> {
    private final FileAppendTransactionBody.Builder builder;

    public FileAppendTransaction() {
        this.builder = FileAppendTransactionBody.newBuilder();
        this.setMaxTransactionFee(new Hbar(5L));
    }

    FileAppendTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (FileAppendTransactionBody.Builder)this.bodyBuilder.getFileAppend().toBuilder();
        for (int i = 0; i < this.signedTransactions.size(); i += this.nodeAccountIds.size()) {
            this.data = this.data.concat(TransactionBody.parseFrom(((SignedTransaction.Builder)this.signedTransactions.get(i)).getBodyBytes()).getFileAppend().getContents());
        }
    }

    @Nullable
    public FileId getFileId() {
        return this.builder.hasFileID() ? FileId.fromProtobuf(this.builder.getFileID()) : null;
    }

    public FileAppendTransaction setFileId(FileId fileId) {
        this.requireNotFrozen();
        this.builder.setFileID(fileId.toProtobuf());
        return this;
    }

    @Nullable
    public ByteString getContents() {
        return this.getData();
    }

    public FileAppendTransaction setContents(byte[] contents) {
        return (FileAppendTransaction)this.setData(contents);
    }

    public FileAppendTransaction setContents(ByteString contents) {
        return (FileAppendTransaction)this.setData(contents);
    }

    public FileAppendTransaction setContents(String text) {
        return (FileAppendTransaction)this.setData(text);
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return FileServiceGrpc.getAppendContentMethod();
    }

    @Override
    void onFreezeChunk(TransactionBody.Builder body, TransactionID initialTransactionId, int startIndex, int endIndex, int chunk, int total) {
        body.setFileAppend(this.builder.setContents(this.data.substring(startIndex, endIndex)));
    }

    @Override
    boolean shouldGetReceipt() {
        return true;
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setFileAppend(this.builder);
        return true;
    }
}

