/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.HbarUnit;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;

public final class Hbar
implements Comparable<Hbar> {
    private final long valueInTinybar;
    public static final Hbar ZERO = Hbar.fromTinybars(0L);
    public static final Hbar MAX = Hbar.from(50000000000L);
    public static final Hbar MIN = Hbar.from(-50000000000L);

    public Hbar(long amount) {
        this(amount, HbarUnit.HBAR);
    }

    Hbar(long amount, HbarUnit unit) {
        this.valueInTinybar = amount * unit.tinybar;
    }

    public Hbar(BigDecimal amount) {
        this(amount, HbarUnit.HBAR);
    }

    Hbar(BigDecimal amount, HbarUnit unit) {
        BigDecimal tinybars = amount.multiply(BigDecimal.valueOf(unit.tinybar));
        if (tinybars.doubleValue() % 1.0 != 0.0) {
            throw new IllegalArgumentException("Amount and Unit combination results in a fractional value for tinybar.  Ensure tinybar value is a whole number.");
        }
        this.valueInTinybar = tinybars.longValue();
    }

    public static Hbar fromString(CharSequence text) {
        return new Hbar(new BigDecimal(text.toString()), HbarUnit.HBAR);
    }

    public static Hbar fromString(CharSequence text, HbarUnit unit) {
        return new Hbar(new BigDecimal(text.toString()), unit);
    }

    public static Hbar from(long hbars) {
        return new Hbar(hbars, HbarUnit.HBAR);
    }

    public static Hbar from(long amount, HbarUnit unit) {
        return new Hbar(amount, unit);
    }

    public static Hbar from(BigDecimal hbars) {
        return new Hbar(hbars, HbarUnit.HBAR);
    }

    public static Hbar from(BigDecimal amount, HbarUnit unit) {
        return new Hbar(amount, unit);
    }

    public static Hbar fromTinybars(long tinybars) {
        return new Hbar(tinybars, HbarUnit.TINYBAR);
    }

    public BigDecimal to(HbarUnit unit) {
        return BigDecimal.valueOf(this.valueInTinybar).divide(BigDecimal.valueOf(unit.tinybar), MathContext.UNLIMITED);
    }

    public long toTinybars() {
        return this.valueInTinybar;
    }

    public BigDecimal getValue() {
        return this.to(HbarUnit.HBAR);
    }

    public Hbar negated() {
        return Hbar.fromTinybars(-this.valueInTinybar);
    }

    public String toString() {
        if (this.valueInTinybar < 10000L && this.valueInTinybar > -10000L) {
            return Long.toString(this.valueInTinybar) + " " + HbarUnit.TINYBAR.getSymbol();
        }
        return this.to(HbarUnit.HBAR).toString() + " " + HbarUnit.HBAR.getSymbol();
    }

    public String toString(HbarUnit unit) {
        return this.to(unit).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hbar hbar = (Hbar)o;
        return this.valueInTinybar == hbar.valueInTinybar;
    }

    public int hashCode() {
        return Objects.hash(this.valueInTinybar);
    }

    @Override
    public int compareTo(Hbar o) {
        return Long.compare(this.valueInTinybar, o.valueInTinybar);
    }
}

