/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.KeyList;
import com.hedera.hashgraph.sdk.PublicKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public abstract class Key {
    static final ASN1ObjectIdentifier ID_ED25519 = new ASN1ObjectIdentifier("1.3.101.112");

    static Key fromProtobufKey(com.hedera.hashgraph.sdk.proto.Key key) {
        switch (key.getKeyCase()) {
            case ED25519: {
                return new PublicKey(key.getEd25519().toByteArray());
            }
            case KEYLIST: {
                return KeyList.fromProtobuf(key.getKeyList(), null);
            }
            case THRESHOLDKEY: {
                return KeyList.fromProtobuf(key.getThresholdKey().getKeys(), key.getThresholdKey().getThreshold());
            }
            case CONTRACTID: {
                return ContractId.fromProtobuf(key.getContractID());
            }
        }
        throw new IllegalStateException("Key#fromProtobuf: unhandled key case: " + key.getKeyCase());
    }

    abstract com.hedera.hashgraph.sdk.proto.Key toProtobufKey();

    public byte[] toBytes() {
        return this.toProtobufKey().toByteArray();
    }
}

