/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.CryptoDeleteLiveHashTransactionBody;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class LiveHashDeleteTransaction
extends com.hedera.hashgraph.sdk.Transaction<LiveHashDeleteTransaction> {
    private final CryptoDeleteLiveHashTransactionBody.Builder builder;

    public LiveHashDeleteTransaction() {
        this.builder = CryptoDeleteLiveHashTransactionBody.newBuilder();
    }

    LiveHashDeleteTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (CryptoDeleteLiveHashTransactionBody.Builder)this.bodyBuilder.getCryptoDeleteLiveHash().toBuilder();
    }

    @Nullable
    public AccountId getAccountId() {
        return this.builder.hasAccountOfLiveHash() ? AccountId.fromProtobuf(this.builder.getAccountOfLiveHash()) : null;
    }

    public LiveHashDeleteTransaction setAccountId(AccountId accountId) {
        this.requireNotFrozen();
        this.builder.setAccountOfLiveHash(accountId.toProtobuf());
        return this;
    }

    public ByteString getHash() {
        return this.builder.getLiveHashToDelete();
    }

    public LiveHashDeleteTransaction setHash(byte[] hash) {
        return this.setHash(ByteString.copyFrom((byte[])hash));
    }

    public LiveHashDeleteTransaction setHash(ByteString hash) {
        this.requireNotFrozen();
        this.builder.setLiveHashToDelete(hash);
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return CryptoServiceGrpc.getDeleteLiveHashMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setCryptoDeleteLiveHash(this.builder);
        return true;
    }
}

