/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.LiveHash;
import com.hedera.hashgraph.sdk.Query;
import com.hedera.hashgraph.sdk.proto.CryptoGetLiveHashQuery;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Query;
import com.hedera.hashgraph.sdk.proto.QueryHeader;
import com.hedera.hashgraph.sdk.proto.Response;
import com.hedera.hashgraph.sdk.proto.ResponseHeader;
import io.grpc.MethodDescriptor;

public final class LiveHashQuery
extends Query<LiveHash, LiveHashQuery> {
    private final CryptoGetLiveHashQuery.Builder builder = CryptoGetLiveHashQuery.newBuilder();

    public AccountId getAccountId() {
        return AccountId.fromProtobuf(this.builder.getAccountID());
    }

    public LiveHashQuery setAccountId(AccountId accountId) {
        this.builder.setAccountID(accountId.toProtobuf());
        return this;
    }

    public ByteString getHash() {
        return this.builder.getHash();
    }

    public LiveHashQuery setHash(byte[] hash) {
        this.builder.setHash(ByteString.copyFrom((byte[])hash));
        return this;
    }

    @Override
    void onMakeRequest(Query.Builder queryBuilder, QueryHeader header) {
        queryBuilder.setCryptoGetLiveHash(this.builder.setHeader(header));
    }

    @Override
    LiveHash mapResponse(Response response, AccountId nodeId, com.hedera.hashgraph.sdk.proto.Query request) {
        return LiveHash.fromProtobuf(response.getCryptoGetLiveHash().getLiveHash());
    }

    @Override
    ResponseHeader mapResponseHeader(Response response) {
        return response.getCryptoGetLiveHash().getHeader();
    }

    @Override
    QueryHeader mapRequestHeader(com.hedera.hashgraph.sdk.proto.Query request) {
        return request.getCryptoGetLiveHash().getHeader();
    }

    @Override
    MethodDescriptor<com.hedera.hashgraph.sdk.proto.Query, Response> getMethodDescriptor() {
        return CryptoServiceGrpc.getCryptoGetBalanceMethod();
    }
}

