/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.time.Instant;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

abstract class ManagedNode {
    String address;
    ManagedChannel channel;
    final ExecutorService executor;
    long lastUsed = 0L;
    long useCount = 0L;

    ManagedNode(String address, ExecutorService executor) {
        this.executor = executor;
        this.address = address;
    }

    void inUse() {
        ++this.useCount;
        this.lastUsed = Instant.now().toEpochMilli();
    }

    synchronized ManagedChannel getChannel() {
        if (this.channel != null) {
            return this.channel;
        }
        this.channel = ManagedChannelBuilder.forTarget((String)this.address).usePlaintext().userAgent(this.getUserAgent()).executor((Executor)this.executor).build();
        return this.channel;
    }

    void close(long seconds) throws InterruptedException {
        if (this.channel != null) {
            this.channel.shutdown();
            this.channel.awaitTermination(seconds, TimeUnit.SECONDS);
            this.channel = null;
        }
    }

    private String getUserAgent() {
        Package thePackage = this.getClass().getPackage();
        String implementationVersion = thePackage != null ? thePackage.getImplementationVersion() : null;
        return "hedera-sdk-java/" + (String)(implementationVersion != null ? "v" + implementationVersion : "DEV");
    }
}

