/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.ManagedNode;
import java.time.Instant;
import java.util.concurrent.ExecutorService;

class Node
extends ManagedNode
implements Comparable<Node> {
    AccountId accountId;
    long delay;
    long delayUntil;

    Node(AccountId accountId, String address, ExecutorService executor) {
        super(address, executor);
        this.accountId = accountId;
        this.delay = 250L;
        this.delayUntil = 0L;
        this.useCount = 0L;
    }

    boolean isHealthy() {
        return this.delayUntil < Instant.now().toEpochMilli();
    }

    void increaseDelay() {
        this.delay = Math.min(this.delay * 2L, 8000L);
    }

    void decreaseDelay() {
        this.delay = Math.max(this.delay / 2L, 250L);
    }

    long delay() {
        return this.delayUntil - Instant.now().toEpochMilli();
    }

    @Override
    public int compareTo(Node node) {
        if (this.isHealthy() && node.isHealthy()) {
            return this.compareToSameHealth(node);
        }
        if (this.isHealthy() && !node.isHealthy()) {
            return -1;
        }
        if (!this.isHealthy() && node.isHealthy()) {
            return 1;
        }
        return this.compareToSameHealth(node);
    }

    private int compareToSameHealth(Node node) {
        if (this.useCount < node.useCount) {
            return -1;
        }
        if (this.useCount > node.useCount) {
            return 1;
        }
        if (this.lastUsed < node.lastUsed) {
            return -1;
        }
        if (this.lastUsed > node.lastUsed) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.accountId.toString();
    }
}

