/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ScheduleCreateTransactionBody;
import com.hedera.hashgraph.sdk.proto.ScheduleServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SignatureMap;
import com.hedera.hashgraph.sdk.proto.SignaturePair;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ScheduleCreateTransaction
extends com.hedera.hashgraph.sdk.Transaction<ScheduleCreateTransaction> {
    private final ScheduleCreateTransactionBody.Builder builder;

    public ScheduleCreateTransaction() {
        this.builder = ScheduleCreateTransactionBody.newBuilder();
        this.setMaxTransactionFee(new Hbar(5L));
    }

    ScheduleCreateTransaction(List<AccountId> nodeAccountIds, ByteString bodyBytes, SignatureMap signatureMap) {
        this();
        this.nodeAccountIds = nodeAccountIds;
        this.builder.setTransactionBody(bodyBytes);
        this.builder.mergeSigMap(signatureMap);
    }

    ScheduleCreateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (ScheduleCreateTransactionBody.Builder)this.bodyBuilder.getScheduleCreate().toBuilder();
    }

    public Map<PublicKey, byte[]> getScheduleSignatures() {
        HashMap<PublicKey, byte[]> map = new HashMap<PublicKey, byte[]>();
        for (SignaturePair sigPair : this.builder.getSigMap().getSigPairList()) {
            map.put(PublicKey.fromBytes(sigPair.getPubKeyPrefix().toByteArray()), sigPair.getEd25519().toByteArray());
        }
        return map;
    }

    public ScheduleCreateTransaction addScheduleSignature(PublicKey publicKey, byte[] signature) {
        SignatureMap.Builder sigMap = (SignatureMap.Builder)this.builder.getSigMap().toBuilder();
        sigMap.addSigPair(publicKey.toSignaturePairProtobuf(signature));
        this.builder.setSigMap(sigMap);
        return this;
    }

    public AccountId getPayerAccountId() {
        return AccountId.fromProtobuf(this.builder.getPayerAccountID());
    }

    public ScheduleCreateTransaction setPayerAccountId(AccountId id) {
        this.requireNotFrozen();
        this.builder.setPayerAccountID(id.toProtobuf());
        return this;
    }

    public Key getAdminKey() {
        return Key.fromProtobufKey(this.builder.getAdminKey());
    }

    public ScheduleCreateTransaction setAdminKey(Key key) {
        this.requireNotFrozen();
        this.builder.setAdminKey(key.toProtobufKey());
        return this;
    }

    public ScheduleCreateTransaction setTransaction(com.hedera.hashgraph.sdk.Transaction<?> transaction) {
        this.requireNotFrozen();
        this.builder.setTransactionBody(transaction.signedTransactions.get(0).getBodyBytes());
        this.builder.mergeSigMap((SignatureMap)transaction.signatures.get(0).build());
        return this;
    }

    public String getMemo() {
        return this.builder.getMemo();
    }

    public ScheduleCreateTransaction setMemo(String memo) {
        this.requireNotFrozen();
        this.builder.setMemo(memo);
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return ScheduleServiceGrpc.getCreateScheduleMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setScheduleCreate(this.builder);
        return true;
    }

    @Override
    final com.hedera.hashgraph.sdk.TransactionResponse mapResponse(TransactionResponse transactionResponse, AccountId nodeId, Transaction request) {
        TransactionId transactionId = Objects.requireNonNull(this.getTransactionId()).setScheduled(true);
        byte[] hash = ScheduleCreateTransaction.hash(request.getSignedTransactionBytes().toByteArray());
        this.nextTransactionIndex = (this.nextTransactionIndex + 1) % this.transactionIds.size();
        return new com.hedera.hashgraph.sdk.TransactionResponse(nodeId, transactionId, hash, transactionId);
    }
}

