/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.EntityIdHelper;
import com.hedera.hashgraph.sdk.proto.ScheduleID;
import java.util.Objects;
import javax.annotation.Nonnegative;

public final class ScheduleId {
    @Nonnegative
    public final long shard;
    @Nonnegative
    public final long realm;
    @Nonnegative
    public final long num;

    public ScheduleId(@Nonnegative long num) {
        this(0L, 0L, num);
    }

    public ScheduleId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num) {
        this.shard = shard;
        this.realm = realm;
        this.num = num;
    }

    public static ScheduleId fromString(String id) {
        return EntityIdHelper.fromString(id, ScheduleId::new);
    }

    static ScheduleId fromProtobuf(ScheduleID ScheduleId2) {
        return new ScheduleId(ScheduleId2.getShardNum(), ScheduleId2.getRealmNum(), ScheduleId2.getScheduleNum());
    }

    public static ScheduleId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return ScheduleId.fromProtobuf((ScheduleID)((ScheduleID.Builder)ScheduleID.parseFrom(bytes).toBuilder()).build());
    }

    ScheduleID toProtobuf() {
        return (ScheduleID)ScheduleID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm).setScheduleNum(this.num).build();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        return this.shard + "." + this.realm + "." + this.num;
    }

    public int hashCode() {
        return Objects.hash(this.shard, this.realm, this.num);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduleId)) {
            return false;
        }
        ScheduleId otherId = (ScheduleId)o;
        return this.shard == otherId.shard && this.realm == otherId.realm && this.num == otherId.num;
    }
}

