/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.ScheduleId;
import com.hedera.hashgraph.sdk.proto.KeyList;
import com.hedera.hashgraph.sdk.proto.ScheduleGetInfoResponse;
import com.hedera.hashgraph.sdk.proto.ScheduleInfo;
import com.hedera.hashgraph.sdk.proto.SignedTransaction;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionList;
import javax.annotation.Nullable;

public final class ScheduleInfo {
    public final ScheduleId scheduleId;
    public final AccountId creatorAccountId;
    public final AccountId payerAccountId;
    public final byte[] transactionBody;
    public final com.hedera.hashgraph.sdk.KeyList signatories;
    @Nullable
    public final Key adminKey;

    private ScheduleInfo(ScheduleId scheduleId, AccountId creatorAccountId, AccountId payerAccountId, byte[] transactionBody, com.hedera.hashgraph.sdk.KeyList signers, @Nullable Key adminKey) {
        this.scheduleId = scheduleId;
        this.creatorAccountId = creatorAccountId;
        this.payerAccountId = payerAccountId;
        this.signatories = signers;
        this.adminKey = adminKey;
        this.transactionBody = transactionBody;
    }

    static ScheduleInfo fromProtobuf(ScheduleGetInfoResponse scheduleInfo) {
        com.hedera.hashgraph.sdk.proto.ScheduleInfo info = scheduleInfo.getScheduleInfo();
        ScheduleId scheduleId = ScheduleId.fromProtobuf(info.getScheduleID());
        AccountId creatorAccountId = AccountId.fromProtobuf(info.getCreatorAccountID());
        AccountId payerAccountId = AccountId.fromProtobuf(info.getPayerAccountID());
        Key adminKey = info.hasAdminKey() ? Key.fromProtobufKey(info.getAdminKey()) : null;
        return new ScheduleInfo(scheduleId, creatorAccountId, payerAccountId, info.getTransactionBody().toByteArray(), com.hedera.hashgraph.sdk.KeyList.fromProtobuf(info.getSignatories(), null), adminKey);
    }

    public static ScheduleInfo fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return ScheduleInfo.fromProtobuf((ScheduleGetInfoResponse)((ScheduleGetInfoResponse.Builder)ScheduleGetInfoResponse.parseFrom(bytes).toBuilder()).build());
    }

    com.hedera.hashgraph.sdk.proto.ScheduleInfo toProtobuf() {
        com.hedera.hashgraph.sdk.proto.Key adminKey = this.adminKey != null ? this.adminKey.toProtobufKey() : null;
        KeyList signers = this.signatories.toProtobuf() != null ? this.signatories.toProtobuf() : null;
        ScheduleInfo.Builder scheduleInfoBuilder = com.hedera.hashgraph.sdk.proto.ScheduleInfo.newBuilder().setScheduleID(this.scheduleId.toProtobuf()).setCreatorAccountID(this.creatorAccountId.toProtobuf()).setTransactionBody(ByteString.copyFrom((byte[])this.transactionBody)).setPayerAccountID(this.payerAccountId.toProtobuf()).setSignatories(signers).setAdminKey(adminKey);
        return (com.hedera.hashgraph.sdk.proto.ScheduleInfo)scheduleInfoBuilder.build();
    }

    public final com.hedera.hashgraph.sdk.Transaction<?> getTransaction() {
        SignedTransaction.Builder builder = SignedTransaction.newBuilder();
        builder.setBodyBytes(ByteString.copyFrom((byte[])this.transactionBody));
        try {
            return com.hedera.hashgraph.sdk.Transaction.fromBytes(((TransactionList)TransactionList.newBuilder().addTransactionList((Transaction)Transaction.newBuilder().setSignedTransactionBytes(((SignedTransaction)builder.build()).toByteString()).build()).build()).toByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Failed to build transaction of `bodyBytes` inside `ScheduleInfo`", e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("scheduleId", (Object)this.scheduleId).add("creatorAccountId", (Object)this.creatorAccountId).add("payerAccountId", (Object)this.payerAccountId).add("signatories", (Object)this.signatories).add("adminKey", (Object)this.adminKey).toString();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

