/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.EntityIdHelper;
import com.hedera.hashgraph.sdk.proto.TokenID;
import java.util.Objects;
import javax.annotation.Nonnegative;

public class TokenId {
    @Nonnegative
    public final long shard;
    @Nonnegative
    public final long realm;
    @Nonnegative
    public final long num;

    public TokenId(@Nonnegative long num) {
        this(0L, 0L, num);
    }

    public TokenId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num) {
        this.shard = shard;
        this.realm = realm;
        this.num = num;
    }

    public static TokenId fromString(String id) {
        return EntityIdHelper.fromString(id, TokenId::new);
    }

    static TokenId fromProtobuf(TokenID topicId) {
        return new TokenId(topicId.getShardNum(), topicId.getRealmNum(), topicId.getTokenNum());
    }

    public static TokenId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TokenId.fromProtobuf((TokenID)((TokenID.Builder)TokenID.parseFrom(bytes).toBuilder()).build());
    }

    TokenID toProtobuf() {
        return (TokenID)TokenID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm).setTokenNum(this.num).build();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        return this.shard + "." + this.realm + "." + this.num;
    }

    public int hashCode() {
        return Objects.hash(this.shard, this.realm, this.num);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TokenId)) {
            return false;
        }
        TokenId otherId = (TokenId)o;
        return this.shard == otherId.shard && this.realm == otherId.realm && this.num == otherId.num;
    }
}

