/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.TokenWipeAccountTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;

public class TokenWipeTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenWipeTransaction> {
    private final TokenWipeAccountTransactionBody.Builder builder;

    public TokenWipeTransaction() {
        this.builder = TokenWipeAccountTransactionBody.newBuilder();
    }

    TokenWipeTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (TokenWipeAccountTransactionBody.Builder)this.bodyBuilder.getTokenWipe().toBuilder();
    }

    public TokenId getTokenId() {
        return TokenId.fromProtobuf(this.builder.getToken());
    }

    public TokenWipeTransaction setTokenId(TokenId tokenId) {
        this.requireNotFrozen();
        this.builder.setToken(tokenId.toProtobuf());
        return this;
    }

    public AccountId getAccountId() {
        return AccountId.fromProtobuf(this.builder.getAccount());
    }

    public TokenWipeTransaction setAccountId(AccountId accountId) {
        this.requireNotFrozen();
        this.builder.setAccount(accountId.toProtobuf());
        return this;
    }

    public long getAmount() {
        return this.builder.getAmount();
    }

    public TokenWipeTransaction setAmount(long amount) {
        this.requireNotFrozen();
        this.builder.setAmount(amount);
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getWipeTokenAccountMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenWipe(this.builder);
        return true;
    }
}

