/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.EntityIdHelper;
import com.hedera.hashgraph.sdk.proto.TopicID;
import java.util.Objects;
import javax.annotation.Nonnegative;

public final class TopicId {
    @Nonnegative
    public final long shard;
    @Nonnegative
    public final long realm;
    @Nonnegative
    public final long num;

    public TopicId(@Nonnegative long num) {
        this(0L, 0L, num);
    }

    public TopicId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num) {
        this.shard = shard;
        this.realm = realm;
        this.num = num;
    }

    public static TopicId fromString(String id) {
        return EntityIdHelper.fromString(id, TopicId::new);
    }

    static TopicId fromProtobuf(TopicID topicId) {
        return new TopicId(topicId.getShardNum(), topicId.getRealmNum(), topicId.getTopicNum());
    }

    public static TopicId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TopicId.fromProtobuf((TopicID)((TopicID.Builder)TopicID.parseFrom(bytes).toBuilder()).build());
    }

    TopicID toProtobuf() {
        return (TopicID)TopicID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm).setTopicNum(this.num).build();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        return this.shard + "." + this.realm + "." + this.num;
    }

    public int hashCode() {
        return Objects.hash(this.shard, this.realm, this.num);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopicId)) {
            return false;
        }
        TopicId otherId = (TopicId)o;
        return this.shard == otherId.shard && this.realm == otherId.realm && this.num == otherId.num;
    }
}

