/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TopicId;
import com.hedera.hashgraph.sdk.proto.ConsensusGetTopicInfoResponse;
import com.hedera.hashgraph.sdk.proto.ConsensusTopicInfo;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;

public final class TopicInfo {
    public final TopicId topicId;
    public final String topicMemo;
    public final ByteString runningHash;
    public final long sequenceNumber;
    public final Instant expirationTime;
    @Nullable
    public final Key adminKey;
    @Nullable
    public final Key submitKey;
    public final Duration autoRenewPeriod;
    @Nullable
    public final AccountId autoRenewAccountId;

    private TopicInfo(TopicId topicId, String topicMemo, ByteString runningHash, long sequenceNumber, Instant expirationTime, @Nullable Key adminKey, @Nullable Key submitKey, Duration autoRenewPeriod, @Nullable AccountId autoRenewAccountId) {
        this.topicId = topicId;
        this.topicMemo = topicMemo;
        this.runningHash = runningHash;
        this.sequenceNumber = sequenceNumber;
        this.expirationTime = expirationTime;
        this.adminKey = adminKey;
        this.submitKey = submitKey;
        this.autoRenewPeriod = autoRenewPeriod;
        this.autoRenewAccountId = autoRenewAccountId;
    }

    static TopicInfo fromProtobuf(ConsensusGetTopicInfoResponse topicInfoResponse) {
        ConsensusTopicInfo topicInfo = topicInfoResponse.getTopicInfo();
        Key adminKey = topicInfo.hasAdminKey() ? Key.fromProtobufKey(topicInfo.getAdminKey()) : null;
        Key submitKey = topicInfo.hasSubmitKey() ? Key.fromProtobufKey(topicInfo.getSubmitKey()) : null;
        AccountId autoRenewAccountId = topicInfo.hasAutoRenewAccount() ? AccountId.fromProtobuf(topicInfo.getAutoRenewAccount()) : null;
        return new TopicInfo(TopicId.fromProtobuf(topicInfoResponse.getTopicID()), topicInfo.getMemo(), topicInfo.getRunningHash(), topicInfo.getSequenceNumber(), InstantConverter.fromProtobuf(topicInfo.getExpirationTime()), adminKey, submitKey, DurationConverter.fromProtobuf(topicInfo.getAutoRenewPeriod()), autoRenewAccountId);
    }

    public static TopicInfo fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TopicInfo.fromProtobuf((ConsensusGetTopicInfoResponse)((ConsensusGetTopicInfoResponse.Builder)ConsensusGetTopicInfoResponse.parseFrom(bytes).toBuilder()).build());
    }

    ConsensusGetTopicInfoResponse toProtobuf() {
        ConsensusGetTopicInfoResponse.Builder topicInfoResponseBuilder = ConsensusGetTopicInfoResponse.newBuilder().setTopicID(this.topicId.toProtobuf());
        ConsensusTopicInfo.Builder topicInfoBuilder = ConsensusTopicInfo.newBuilder().setMemo(this.topicMemo).setRunningHash(this.runningHash).setSequenceNumber(this.sequenceNumber).setExpirationTime(InstantConverter.toProtobuf(this.expirationTime)).setAutoRenewPeriod(DurationConverter.toProtobuf(this.autoRenewPeriod));
        if (this.adminKey != null) {
            topicInfoBuilder.setAdminKey(this.adminKey.toProtobufKey());
        }
        if (this.submitKey != null) {
            topicInfoBuilder.setSubmitKey(this.submitKey.toProtobufKey());
        }
        if (this.autoRenewAccountId != null) {
            topicInfoBuilder.setAutoRenewAccount(this.autoRenewAccountId.toProtobuf());
        }
        return (ConsensusGetTopicInfoResponse)topicInfoResponseBuilder.setTopicInfo(topicInfoBuilder).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topicId", (Object)this.topicId).add("topicMemo", (Object)this.topicMemo).add("runningHash", (Object)this.runningHash.toByteArray()).add("sequenceNumber", this.sequenceNumber).add("expirationTime", (Object)this.expirationTime).add("adminKey", (Object)this.adminKey).add("submitKey", (Object)this.submitKey).add("autoRenewPeriod", (Object)this.autoRenewPeriod).add("autoRenewAccountId", (Object)this.autoRenewAccountId).toString();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

