/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.SubscriptionHandle;
import com.hedera.hashgraph.sdk.TopicId;
import com.hedera.hashgraph.sdk.TopicMessage;
import com.hedera.hashgraph.sdk.proto.TransactionID;
import com.hedera.hashgraph.sdk.proto.mirror.ConsensusServiceGrpc;
import com.hedera.hashgraph.sdk.proto.mirror.ConsensusTopicQuery;
import com.hedera.hashgraph.sdk.proto.mirror.ConsensusTopicResponse;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class TopicMessageQuery {
    private final ConsensusTopicQuery.Builder builder = ConsensusTopicQuery.newBuilder();
    @Nullable
    private BiConsumer<Throwable, TopicMessage> errorHandler;

    public TopicMessageQuery setTopicId(TopicId topicId) {
        this.builder.setTopicID(topicId.toProtobuf());
        return this;
    }

    public TopicMessageQuery setStartTime(Instant startTime) {
        this.builder.setConsensusStartTime(InstantConverter.toProtobuf(startTime));
        return this;
    }

    public TopicMessageQuery setEndTime(Instant endTime) {
        this.builder.setConsensusEndTime(InstantConverter.toProtobuf(endTime));
        return this;
    }

    public TopicMessageQuery setLimit(long limit) {
        this.builder.setLimit(limit);
        return this;
    }

    public TopicMessageQuery setErrorHandler(BiConsumer<Throwable, TopicMessage> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public SubscriptionHandle subscribe(Client client, Consumer<TopicMessage> onNext) {
        SubscriptionHandle subscriptionHandle = new SubscriptionHandle();
        TopicMessageQuery.makeStreamingCall(client, subscriptionHandle, this.errorHandler, (ConsensusTopicQuery)this.builder.build(), onNext, 0, new Instant[]{null});
        return subscriptionHandle;
    }

    private static void makeStreamingCall(final Client client, final SubscriptionHandle subscriptionHandle, final @Nullable BiConsumer<Throwable, TopicMessage> errorHandler, final ConsensusTopicQuery query, final Consumer<TopicMessage> onNext, final int attempt, final Instant[] startTime) {
        if (attempt > 10 && errorHandler != null) {
            errorHandler.accept(new Error("Failed to connect to mirror node"), null);
            return;
        }
        final ClientCall call = client.mirrorNetwork.getNextMirrorNode().getChannel().newCall(ConsensusServiceGrpc.getSubscribeTopicMethod(), CallOptions.DEFAULT);
        subscriptionHandle.setOnUnsubscribe(() -> call.cancel("unsubscribe", null));
        final HashMap pendingMessages = new HashMap();
        ClientCalls.asyncServerStreamingCall((ClientCall)call, (Object)query, (StreamObserver)new StreamObserver<ConsensusTopicResponse>(){

            public void onNext(ConsensusTopicResponse consensusTopicResponse) {
                block8: {
                    if (!consensusTopicResponse.hasChunkInfo()) {
                        block7: {
                            TopicMessage message = TopicMessage.ofSingle(consensusTopicResponse);
                            startTime[0] = message.consensusTimestamp;
                            try {
                                onNext.accept(message);
                            }
                            catch (Throwable e) {
                                if (errorHandler == null) break block7;
                                errorHandler.accept(e, message);
                            }
                        }
                        return;
                    }
                    TransactionID initialTransactionID = consensusTopicResponse.getChunkInfo().getInitialTransactionID();
                    if (!pendingMessages.containsKey(initialTransactionID)) {
                        pendingMessages.put(initialTransactionID, new ArrayList());
                    }
                    ArrayList chunks = (ArrayList)pendingMessages.get(initialTransactionID);
                    Objects.requireNonNull(chunks).add(consensusTopicResponse);
                    if (chunks.size() == consensusTopicResponse.getChunkInfo().getTotal()) {
                        TopicMessage message = TopicMessage.ofMany(chunks);
                        startTime[0] = message.consensusTimestamp;
                        try {
                            onNext.accept(message);
                        }
                        catch (Throwable e) {
                            if (errorHandler == null) break block8;
                            errorHandler.accept(e, null);
                        }
                    }
                }
            }

            public void onError(Throwable t) {
                if (t instanceof StatusRuntimeException) {
                    StatusRuntimeException status = (StatusRuntimeException)t;
                    if (status.getStatus().getCode().equals((Object)Status.NOT_FOUND.getCode()) || status.getStatus().getCode().equals((Object)Status.UNAVAILABLE.getCode())) {
                        try {
                            Thread.sleep(250L * (long)Math.pow(2.0, attempt));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (startTime[0] != null) {
                            startTime[0] = startTime[0].plusNanos(1L);
                        }
                        call.cancel("unsubscribed", null);
                        TopicMessageQuery.makeStreamingCall(client, subscriptionHandle, errorHandler, query, onNext, attempt + 1, startTime);
                    }
                } else if (errorHandler != null) {
                    errorHandler.accept(t, null);
                }
            }

            public void onCompleted() {
            }
        });
    }
}

