/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.ChunkedTransaction;
import com.hedera.hashgraph.sdk.TopicId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ConsensusMessageChunkInfo;
import com.hedera.hashgraph.sdk.proto.ConsensusServiceGrpc;
import com.hedera.hashgraph.sdk.proto.ConsensusSubmitMessageTransactionBody;
import com.hedera.hashgraph.sdk.proto.SignedTransaction;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionID;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class TopicMessageSubmitTransaction
extends ChunkedTransaction<TopicMessageSubmitTransaction> {
    private final ConsensusSubmitMessageTransactionBody.Builder builder;

    public TopicMessageSubmitTransaction() {
        this.builder = ConsensusSubmitMessageTransactionBody.newBuilder();
    }

    TopicMessageSubmitTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (ConsensusSubmitMessageTransactionBody.Builder)this.bodyBuilder.getConsensusSubmitMessage().toBuilder();
        for (int i = 0; i < this.signedTransactions.size(); i += this.nodeAccountIds.size()) {
            this.data = this.data.concat(TransactionBody.parseFrom(((SignedTransaction.Builder)this.signedTransactions.get(i)).getBodyBytes()).getConsensusSubmitMessage().getMessage());
        }
    }

    @Nullable
    public TopicId getTopicId() {
        return this.builder.hasTopicID() ? TopicId.fromProtobuf(this.builder.getTopicID()) : null;
    }

    public TopicMessageSubmitTransaction setTopicId(TopicId topicId) {
        this.requireNotFrozen();
        this.builder.setTopicID(topicId.toProtobuf());
        return this;
    }

    public ByteString getMessage() {
        return this.getData();
    }

    public TopicMessageSubmitTransaction setMessage(ByteString message) {
        return (TopicMessageSubmitTransaction)this.setData(message);
    }

    public TopicMessageSubmitTransaction setMessage(byte[] message) {
        return (TopicMessageSubmitTransaction)this.setData(message);
    }

    public TopicMessageSubmitTransaction setMessage(String message) {
        return (TopicMessageSubmitTransaction)this.setData(message);
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return ConsensusServiceGrpc.getSubmitMessageMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setConsensusSubmitMessage(this.builder);
        return true;
    }

    @Override
    void onFreezeChunk(TransactionBody.Builder body, TransactionID initialTransactionId, int startIndex, int endIndex, int chunk, int total) {
        body.setConsensusSubmitMessage(this.builder.setMessage(this.data.substring(startIndex, endIndex)).setChunkInfo(ConsensusMessageChunkInfo.newBuilder().setInitialTransactionID(initialTransactionId).setNumber(chunk + 1).setTotal(total)));
    }
}

