/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountCreateTransaction;
import com.hedera.hashgraph.sdk.AccountDeleteTransaction;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.AccountUpdateTransaction;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ContractCreateTransaction;
import com.hedera.hashgraph.sdk.ContractDeleteTransaction;
import com.hedera.hashgraph.sdk.ContractExecuteTransaction;
import com.hedera.hashgraph.sdk.ContractUpdateTransaction;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.Executable;
import com.hedera.hashgraph.sdk.FileAppendTransaction;
import com.hedera.hashgraph.sdk.FileCreateTransaction;
import com.hedera.hashgraph.sdk.FileDeleteTransaction;
import com.hedera.hashgraph.sdk.FileUpdateTransaction;
import com.hedera.hashgraph.sdk.FreezeTransaction;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.LiveHashAddTransaction;
import com.hedera.hashgraph.sdk.LiveHashDeleteTransaction;
import com.hedera.hashgraph.sdk.PrivateKey;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.ScheduleCreateTransaction;
import com.hedera.hashgraph.sdk.ScheduleDeleteTransaction;
import com.hedera.hashgraph.sdk.ScheduleSignTransaction;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.SystemDeleteTransaction;
import com.hedera.hashgraph.sdk.SystemUndeleteTransaction;
import com.hedera.hashgraph.sdk.TokenAssociateTransaction;
import com.hedera.hashgraph.sdk.TokenBurnTransaction;
import com.hedera.hashgraph.sdk.TokenCreateTransaction;
import com.hedera.hashgraph.sdk.TokenDeleteTransaction;
import com.hedera.hashgraph.sdk.TokenDissociateTransaction;
import com.hedera.hashgraph.sdk.TokenFreezeTransaction;
import com.hedera.hashgraph.sdk.TokenGrantKycTransaction;
import com.hedera.hashgraph.sdk.TokenMintTransaction;
import com.hedera.hashgraph.sdk.TokenRevokeKycTransaction;
import com.hedera.hashgraph.sdk.TokenUnfreezeTransaction;
import com.hedera.hashgraph.sdk.TokenUpdateTransaction;
import com.hedera.hashgraph.sdk.TokenWipeTransaction;
import com.hedera.hashgraph.sdk.TopicCreateTransaction;
import com.hedera.hashgraph.sdk.TopicDeleteTransaction;
import com.hedera.hashgraph.sdk.TopicMessageSubmitTransaction;
import com.hedera.hashgraph.sdk.TopicUpdateTransaction;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionResponse;
import com.hedera.hashgraph.sdk.TransferTransaction;
import com.hedera.hashgraph.sdk.proto.SignatureMap;
import com.hedera.hashgraph.sdk.proto.SignaturePair;
import com.hedera.hashgraph.sdk.proto.SignedTransaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionList;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.bouncycastle.crypto.digests.SHA384Digest;

public abstract class Transaction<T extends Transaction<T>>
extends Executable<T, com.hedera.hashgraph.sdk.proto.Transaction, com.hedera.hashgraph.sdk.proto.TransactionResponse, TransactionResponse> {
    static final Duration DEFAULT_AUTO_RENEW_PERIOD = Duration.ofDays(90L);
    private static final Duration DEFAULT_TRANSACTION_VALID_DURATION = Duration.ofSeconds(120L);
    protected TransactionBody.Builder bodyBuilder;
    protected List<com.hedera.hashgraph.sdk.proto.Transaction> transactions = Collections.emptyList();
    protected List<SignedTransaction.Builder> signedTransactions = Collections.emptyList();
    protected List<SignatureMap.Builder> signatures = Collections.emptyList();
    protected List<TransactionId> transactionIds = Collections.emptyList();
    int nextTransactionIndex = 0;

    Transaction() {
        this.bodyBuilder = TransactionBody.newBuilder();
        this.bodyBuilder.setTransactionValidDuration(DurationConverter.toProtobuf(DEFAULT_TRANSACTION_VALID_DURATION));
        this.bodyBuilder.setTransactionFee(new Hbar(2L).toTinybars());
    }

    Transaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, com.hedera.hashgraph.sdk.proto.Transaction>> txs) throws InvalidProtocolBufferException {
        int size = txs.values().iterator().next().size();
        this.nodeAccountIds = new ArrayList(size);
        this.signatures = new ArrayList<SignatureMap.Builder>(size * txs.keySet().size());
        this.transactions = new ArrayList<com.hedera.hashgraph.sdk.proto.Transaction>(size * txs.keySet().size());
        this.signedTransactions = new ArrayList<SignedTransaction.Builder>(size * txs.keySet().size());
        this.transactionIds = new ArrayList<TransactionId>(txs.keySet().size());
        for (Map.Entry<TransactionId, LinkedHashMap<AccountId, com.hedera.hashgraph.sdk.proto.Transaction>> transactionEntry : txs.entrySet()) {
            this.transactionIds.add(transactionEntry.getKey());
            for (Map.Entry<AccountId, com.hedera.hashgraph.sdk.proto.Transaction> nodeEntry : transactionEntry.getValue().entrySet()) {
                if (this.nodeAccountIds.size() != size) {
                    this.nodeAccountIds.add(nodeEntry.getKey());
                }
                SignedTransaction transaction = SignedTransaction.parseFrom(nodeEntry.getValue().getSignedTransactionBytes());
                this.transactions.add(nodeEntry.getValue());
                this.signatures.add((SignatureMap.Builder)transaction.getSigMap().toBuilder());
                this.signedTransactions.add((SignedTransaction.Builder)transaction.toBuilder());
            }
        }
        this.bodyBuilder = (TransactionBody.Builder)TransactionBody.parseFrom(this.signedTransactions.get(0).getBodyBytes()).toBuilder();
    }

    public static Transaction<?> fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        LinkedHashMap<TransactionId, LinkedHashMap<AccountId, com.hedera.hashgraph.sdk.proto.Transaction>> txs = new LinkedHashMap<TransactionId, LinkedHashMap<AccountId, com.hedera.hashgraph.sdk.proto.Transaction>>();
        TransactionBody.DataCase dataCase = TransactionBody.DataCase.DATA_NOT_SET;
        TransactionList list = TransactionList.parseFrom(bytes);
        for (com.hedera.hashgraph.sdk.proto.Transaction transaction : list.getTransactionListList()) {
            SignedTransaction signedTransaction = SignedTransaction.parseFrom(transaction.getSignedTransactionBytes());
            TransactionBody txBody = TransactionBody.parseFrom(signedTransaction.getBodyBytes());
            if (dataCase.getNumber() == TransactionBody.DataCase.DATA_NOT_SET.getNumber()) {
                dataCase = txBody.getDataCase();
            }
            AccountId account = AccountId.fromProtobuf(txBody.getNodeAccountID());
            TransactionId transactionId = TransactionId.fromProtobuf(txBody.getTransactionID());
            txs.computeIfAbsent(transactionId, k -> new LinkedHashMap()).put(account, transaction);
        }
        switch (dataCase) {
            case CONTRACTCALL: {
                return new ContractExecuteTransaction(txs);
            }
            case CONTRACTCREATEINSTANCE: {
                return new ContractCreateTransaction(txs);
            }
            case CONTRACTUPDATEINSTANCE: {
                return new ContractUpdateTransaction(txs);
            }
            case CONTRACTDELETEINSTANCE: {
                return new ContractDeleteTransaction(txs);
            }
            case CRYPTOADDLIVEHASH: {
                return new LiveHashAddTransaction(txs);
            }
            case CRYPTOCREATEACCOUNT: {
                return new AccountCreateTransaction(txs);
            }
            case CRYPTODELETE: {
                return new AccountDeleteTransaction(txs);
            }
            case CRYPTODELETELIVEHASH: {
                return new LiveHashDeleteTransaction(txs);
            }
            case CRYPTOTRANSFER: {
                return new TransferTransaction(txs);
            }
            case CRYPTOUPDATEACCOUNT: {
                return new AccountUpdateTransaction(txs);
            }
            case FILEAPPEND: {
                return new FileAppendTransaction(txs);
            }
            case FILECREATE: {
                return new FileCreateTransaction(txs);
            }
            case FILEDELETE: {
                return new FileDeleteTransaction(txs);
            }
            case FILEUPDATE: {
                return new FileUpdateTransaction(txs);
            }
            case SYSTEMDELETE: {
                return new SystemDeleteTransaction(txs);
            }
            case SYSTEMUNDELETE: {
                return new SystemUndeleteTransaction(txs);
            }
            case FREEZE: {
                return new FreezeTransaction(txs);
            }
            case CONSENSUSCREATETOPIC: {
                return new TopicCreateTransaction(txs);
            }
            case CONSENSUSUPDATETOPIC: {
                return new TopicUpdateTransaction(txs);
            }
            case CONSENSUSDELETETOPIC: {
                return new TopicDeleteTransaction(txs);
            }
            case CONSENSUSSUBMITMESSAGE: {
                return new TopicMessageSubmitTransaction(txs);
            }
            case TOKENASSOCIATE: {
                return new TokenAssociateTransaction(txs);
            }
            case TOKENBURN: {
                return new TokenBurnTransaction(txs);
            }
            case TOKENCREATION: {
                return new TokenCreateTransaction(txs);
            }
            case TOKENDELETION: {
                return new TokenDeleteTransaction(txs);
            }
            case TOKENDISSOCIATE: {
                return new TokenDissociateTransaction(txs);
            }
            case TOKENFREEZE: {
                return new TokenFreezeTransaction(txs);
            }
            case TOKENGRANTKYC: {
                return new TokenGrantKycTransaction(txs);
            }
            case TOKENMINT: {
                return new TokenMintTransaction(txs);
            }
            case TOKENREVOKEKYC: {
                return new TokenRevokeKycTransaction(txs);
            }
            case TOKENUNFREEZE: {
                return new TokenUnfreezeTransaction(txs);
            }
            case TOKENUPDATE: {
                return new TokenUpdateTransaction(txs);
            }
            case TOKENWIPE: {
                return new TokenWipeTransaction(txs);
            }
            case SCHEDULECREATE: {
                return new ScheduleCreateTransaction(txs);
            }
            case SCHEDULEDELETE: {
                return new ScheduleDeleteTransaction(txs);
            }
            case SCHEDULESIGN: {
                return new ScheduleSignTransaction(txs);
            }
        }
        throw new IllegalArgumentException("parsed transaction body has no data");
    }

    public final ScheduleCreateTransaction schedule() {
        this.requireOneNodeAccountId();
        return new ScheduleCreateTransaction(this.nodeAccountIds, this.signedTransactions.get(0).getBodyBytes(), (SignatureMap)this.signatures.get(0).build());
    }

    static byte[] hash(byte[] bytes) {
        SHA384Digest digest = new SHA384Digest();
        byte[] hash = new byte[digest.getDigestSize()];
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(hash, 0);
        return hash;
    }

    @Override
    public final T setNodeAccountIds(List<AccountId> nodeAccountIds) {
        this.requireNotFrozen();
        return (T)((Transaction)super.setNodeAccountIds(nodeAccountIds));
    }

    @Nullable
    public final Duration getTransactionValidDuration() {
        return this.bodyBuilder.hasTransactionValidDuration() ? DurationConverter.fromProtobuf(this.bodyBuilder.getTransactionValidDuration()) : null;
    }

    public final T setTransactionValidDuration(Duration validDuration) {
        this.requireNotFrozen();
        this.bodyBuilder.setTransactionValidDuration(DurationConverter.toProtobuf(validDuration));
        return (T)this;
    }

    @Nullable
    public final Hbar getMaxTransactionFee() {
        long transactionFee = this.bodyBuilder.getTransactionFee();
        if (transactionFee == 0L) {
            return null;
        }
        return Hbar.fromTinybars(transactionFee);
    }

    public final T setMaxTransactionFee(Hbar maxTransactionFee) {
        this.requireNotFrozen();
        this.bodyBuilder.setTransactionFee(maxTransactionFee.toTinybars());
        return (T)this;
    }

    public final String getTransactionMemo() {
        return this.bodyBuilder.getMemo();
    }

    public final T setTransactionMemo(String memo) {
        this.requireNotFrozen();
        this.bodyBuilder.setMemo(memo);
        return (T)this;
    }

    public byte[] toBytes() {
        if (!this.isFrozen()) {
            throw new IllegalStateException("transaction must have been frozen before calculating the hash will be stable, try calling `freeze`");
        }
        this.buildTransactions(this.signedTransactions.size());
        TransactionList.Builder list = TransactionList.newBuilder();
        for (com.hedera.hashgraph.sdk.proto.Transaction transaction : this.transactions) {
            list.addTransactionList(transaction);
        }
        return ((TransactionList)list.build()).toByteArray();
    }

    public byte[] getTransactionHash() {
        if (!this.isFrozen()) {
            throw new IllegalStateException("transaction must have been frozen before calculating the hash will be stable, try calling `freeze`");
        }
        int index = this.nextTransactionIndex * this.nodeAccountIds.size() + this.nextNodeIndex;
        this.buildTransactions(index + 1);
        return Transaction.hash(this.transactions.get(index).getSignedTransactionBytes().toByteArray());
    }

    public Map<AccountId, byte[]> getTransactionHashPerNode() {
        if (!this.isFrozen()) {
            throw new IllegalStateException("transaction must have been frozen before calculating the hash will be stable, try calling `freeze`");
        }
        this.buildTransactions(this.signedTransactions.size());
        HashMap<AccountId, byte[]> hashes = new HashMap<AccountId, byte[]>();
        for (int i = 0; i < this.transactions.size(); ++i) {
            hashes.put((AccountId)this.nodeAccountIds.get(i), Transaction.hash(this.transactions.get(i).getSignedTransactionBytes().toByteArray()));
        }
        return hashes;
    }

    @Override
    public final TransactionId getTransactionId() {
        if (this.transactionIds.isEmpty() || !this.isFrozen()) {
            throw new IllegalStateException("transaction must have been frozen before getting the transaction ID, try calling `freeze`");
        }
        return this.transactionIds.get(this.nextTransactionIndex);
    }

    public final T setTransactionId(TransactionId transactionId) {
        this.requireNotFrozen();
        this.transactionIds = Collections.singletonList(transactionId);
        return (T)this;
    }

    public final T sign(PrivateKey privateKey) {
        return this.signWith(privateKey.getPublicKey(), privateKey::sign);
    }

    public T signWith(PublicKey publicKey, Function<byte[], byte[]> transactionSigner) {
        if (!this.isFrozen()) {
            throw new IllegalStateException("Signing requires transaction to be frozen");
        }
        this.transactions.clear();
        for (int i = 0; i < this.signedTransactions.size(); ++i) {
            byte[] bodyBytes = this.signedTransactions.get(i).getBodyBytes().toByteArray();
            byte[] signatureBytes = transactionSigner.apply(bodyBytes);
            this.signatures.get(i).addSigPair(publicKey.toSignaturePairProtobuf(signatureBytes));
        }
        return (T)this;
    }

    public T signWithOperator(Client client) {
        Client.Operator operator = client.getOperator();
        if (operator == null) {
            throw new IllegalStateException("`client` must have an `operator` to sign with the operator");
        }
        if (!this.isFrozen()) {
            this.freezeWith(client);
        }
        if (this.keyAlreadySigned(operator.publicKey)) {
            return (T)this;
        }
        return this.signWith(operator.publicKey, operator.transactionSigner);
    }

    protected boolean keyAlreadySigned(PublicKey key) {
        if (!this.signatures.isEmpty()) {
            for (SignaturePair sigPair : this.signatures.get(0).getSigPairList()) {
                if (!ByteString.copyFrom((byte[])key.toBytes()).startsWith(sigPair.getPubKeyPrefix())) continue;
                return true;
            }
        }
        return false;
    }

    public T addSignature(PublicKey publicKey, byte[] signature) {
        this.requireOneNodeAccountId();
        if (!this.isFrozen()) {
            this.freeze();
        }
        if (this.keyAlreadySigned(publicKey)) {
            return (T)this;
        }
        this.transactions.clear();
        this.signatures.get(0).addSigPair(publicKey.toSignaturePairProtobuf(signature));
        return (T)this;
    }

    public Map<AccountId, Map<PublicKey, byte[]>> getSignatures() {
        HashMap<AccountId, Map<PublicKey, byte[]>> map = new HashMap<AccountId, Map<PublicKey, byte[]>>(this.nodeAccountIds.size());
        if (this.signatures.size() == 0) {
            return map;
        }
        for (int i = 0; i < this.nodeAccountIds.size(); ++i) {
            SignatureMap.Builder sigMap = this.signatures.get(i);
            AccountId nodeAccountId = (AccountId)this.nodeAccountIds.get(i);
            Map keyMap = map.computeIfAbsent(nodeAccountId, k -> new HashMap(sigMap.getSigPairCount()));
            for (SignaturePair sigPair : sigMap.getSigPairList()) {
                keyMap.put(PublicKey.fromBytes(sigPair.getPubKeyPrefix().toByteArray()), sigPair.getEd25519().toByteArray());
            }
        }
        return map;
    }

    protected boolean isFrozen() {
        return !this.signedTransactions.isEmpty();
    }

    protected void requireNotFrozen() {
        if (this.isFrozen()) {
            throw new IllegalStateException("transaction is immutable; it has at least one signature or has been explicitly frozen");
        }
    }

    protected void requireOneNodeAccountId() {
        if (this.signedTransactions.size() != 1) {
            throw new IllegalStateException("transaction did not have exactly one node ID set");
        }
    }

    public T freeze() {
        return this.freezeWith(null);
    }

    public T freezeWith(@Nullable Client client) {
        if (this.isFrozen()) {
            return (T)this;
        }
        if (client != null && this.bodyBuilder.getTransactionFee() == 0L) {
            this.bodyBuilder.setTransactionFee(client.maxTransactionFee.toTinybars());
        }
        if (this.transactionIds.isEmpty() && client != null) {
            Client.Operator operator = client.getOperator();
            if (operator != null) {
                this.setTransactionId(TransactionId.generate(operator.accountId));
            } else {
                throw new IllegalStateException("`client` must have an `operator` or `transactionId` must be set");
            }
        }
        this.bodyBuilder.setTransactionID(this.transactionIds.get(0).toProtobuf());
        if (!this.onFreeze(this.bodyBuilder)) {
            return (T)this;
        }
        if (this.nodeAccountIds.isEmpty()) {
            if (client == null) {
                throw new IllegalStateException("`client` must be provided or both `nodeId` and `transactionId` must be set");
            }
            this.nodeAccountIds = client.network.getNodeAccountIdsForExecute();
        }
        this.transactions = new ArrayList<com.hedera.hashgraph.sdk.proto.Transaction>(this.nodeAccountIds.size());
        this.signatures = new ArrayList<SignatureMap.Builder>(this.nodeAccountIds.size());
        this.signedTransactions = new ArrayList<SignedTransaction.Builder>(this.nodeAccountIds.size());
        for (AccountId nodeId : this.nodeAccountIds) {
            this.signatures.add(SignatureMap.newBuilder());
            this.signedTransactions.add(SignedTransaction.newBuilder().setBodyBytes(((TransactionBody)this.bodyBuilder.setNodeAccountID(nodeId.toProtobuf()).build()).toByteString()));
        }
        return (T)this;
    }

    void buildTransactions(int untilIndex) {
        for (int i = this.transactions.size(); i < untilIndex; ++i) {
            this.transactions.add((com.hedera.hashgraph.sdk.proto.Transaction)com.hedera.hashgraph.sdk.proto.Transaction.newBuilder().setSignedTransactionBytes(((SignedTransaction)this.signedTransactions.get(i).setSigMap(this.signatures.get(i)).build()).toByteString()).build());
        }
    }

    abstract boolean onFreeze(TransactionBody.Builder var1);

    @Override
    final com.hedera.hashgraph.sdk.proto.Transaction makeRequest() {
        int index = this.nextNodeIndex + this.nextTransactionIndex * this.nodeAccountIds.size();
        this.buildTransactions(index + 1);
        return this.transactions.get(index);
    }

    @Override
    TransactionResponse mapResponse(com.hedera.hashgraph.sdk.proto.TransactionResponse transactionResponse, AccountId nodeId, com.hedera.hashgraph.sdk.proto.Transaction request) {
        TransactionId transactionId = Objects.requireNonNull(this.getTransactionId());
        byte[] hash = Transaction.hash(request.getSignedTransactionBytes().toByteArray());
        this.nextTransactionIndex = (this.nextTransactionIndex + 1) % this.transactionIds.size();
        return new TransactionResponse(nodeId, transactionId, hash, null);
    }

    @Override
    final Status mapResponseStatus(com.hedera.hashgraph.sdk.proto.TransactionResponse transactionResponse) {
        return Status.valueOf(transactionResponse.getNodeTransactionPrecheckCode());
    }

    @Override
    CompletableFuture<Void> onExecuteAsync(Client client) {
        AccountId operatorId;
        if (!this.isFrozen()) {
            this.freezeWith(client);
        }
        if ((operatorId = client.getOperatorAccountId()) != null && operatorId.equals(Objects.requireNonNull(this.getTransactionId()).accountId)) {
            this.signWithOperator(client);
        }
        return CompletableFuture.completedFuture(null);
    }

    public String toString() {
        return ((TransactionBody)this.bodyBuilder.buildPartial()).toString().replaceAll("@[A-Za-z0-9]+", "");
    }
}

