/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.ReceiptStatusException;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TransactionReceipt;
import com.hedera.hashgraph.sdk.TransactionReceiptQuery;
import com.hedera.hashgraph.sdk.TransactionRecord;
import com.hedera.hashgraph.sdk.TransactionRecordQuery;
import com.hedera.hashgraph.sdk.WithGetReceipt;
import com.hedera.hashgraph.sdk.WithGetRecord;
import com.hedera.hashgraph.sdk.proto.TransactionID;
import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;

public final class TransactionId
implements WithGetReceipt,
WithGetRecord {
    @Nullable
    public final AccountId accountId;
    @Nullable
    public final Instant validStart;
    @Nullable
    public final byte[] nonce;
    boolean scheduled = false;

    @Deprecated
    public TransactionId(AccountId accountId, Instant validStart) {
        this.accountId = accountId;
        this.validStart = validStart;
        this.scheduled = false;
        this.nonce = null;
    }

    TransactionId(AccountId accountId, Instant validStart, byte[] nonce) {
        this.accountId = accountId;
        this.validStart = validStart;
        this.nonce = nonce;
    }

    public static TransactionId withNonce(byte[] nonce) {
        return new TransactionId(null, null, nonce);
    }

    public static TransactionId withValidStart(AccountId accountId, Instant validStart) {
        return new TransactionId(accountId, validStart, null);
    }

    public static TransactionId generate(AccountId accountId) {
        Instant instant = Clock.systemUTC().instant().minusNanos((long)(Math.random() * 5.0E9 + 8.0E9));
        return new TransactionId(accountId, instant, null);
    }

    static TransactionId fromProtobuf(TransactionID transactionID) {
        return TransactionId.withValidStart(AccountId.fromProtobuf(transactionID.getAccountID()), InstantConverter.fromProtobuf(transactionID.getTransactionValidStart()));
    }

    public static TransactionId fromString(String s) {
        String[] parts = s.split("@", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("expecting {account}@{seconds}.{nanos}");
        }
        AccountId accountId = AccountId.fromString(parts[0]);
        String[] validStartParts = parts[1].split("\\.", 2);
        if (validStartParts.length != 2) {
            throw new IllegalArgumentException("expecting {account}@{seconds}.{nanos}");
        }
        Instant validStart = Instant.ofEpochSecond(Long.parseLong(validStartParts[0]), Long.parseLong(validStartParts[1]));
        return TransactionId.withValidStart(accountId, validStart);
    }

    public static TransactionId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TransactionId.fromProtobuf((TransactionID)((TransactionID.Builder)TransactionID.parseFrom(bytes).toBuilder()).build());
    }

    public boolean getScheduled() {
        return this.scheduled;
    }

    public TransactionId setScheduled(boolean scheduled) {
        this.scheduled = scheduled;
        return this;
    }

    @Override
    public CompletableFuture<TransactionReceipt> getReceiptAsync(Client client) {
        return new TransactionReceiptQuery().setTransactionId(this).executeAsync(client).thenCompose(receipt -> {
            if (receipt.status != Status.SUCCESS) {
                return CompletableFuture.failedFuture(new ReceiptStatusException(this, (TransactionReceipt)receipt));
            }
            return CompletableFuture.completedFuture(receipt);
        });
    }

    @Override
    public CompletableFuture<TransactionRecord> getRecordAsync(Client client) {
        return this.getReceiptAsync(client).thenCompose(receipt -> new TransactionRecordQuery().setTransactionId(this).executeAsync(client));
    }

    TransactionID toProtobuf() {
        return (TransactionID)TransactionID.newBuilder().setAccountID(this.accountId.toProtobuf()).setTransactionValidStart(InstantConverter.toProtobuf(this.validStart)).build();
    }

    public String toString() {
        if (this.accountId != null && this.validStart != null) {
            return this.accountId + "@" + this.validStart.getEpochSecond() + "." + this.validStart.getNano() + (this.scheduled ? "?scheduled" : "");
        }
        if (this.nonce != null) {
            return Hex.toHexString((byte[])this.nonce) + (this.scheduled ? "?scheduled" : "");
        }
        throw new IllegalStateException("`TransactionId.toString()` is non-exhaustive");
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof TransactionId)) {
            return false;
        }
        return ((TransactionId)object).accountId.equals(this.accountId) && ((TransactionId)object).validStart.equals(this.validStart);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

