/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Query;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionRecord;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Query;
import com.hedera.hashgraph.sdk.proto.QueryHeader;
import com.hedera.hashgraph.sdk.proto.Response;
import com.hedera.hashgraph.sdk.proto.ResponseHeader;
import com.hedera.hashgraph.sdk.proto.TransactionGetRecordQuery;
import io.grpc.MethodDescriptor;

public final class TransactionRecordQuery
extends Query<TransactionRecord, TransactionRecordQuery> {
    private final TransactionGetRecordQuery.Builder builder = TransactionGetRecordQuery.newBuilder();

    @Override
    public TransactionId getTransactionId() {
        return TransactionId.fromProtobuf(this.builder.getTransactionID());
    }

    public TransactionRecordQuery setTransactionId(TransactionId transactionId) {
        this.builder.setTransactionID(transactionId.toProtobuf());
        return this;
    }

    @Override
    void onMakeRequest(Query.Builder queryBuilder, QueryHeader header) {
        queryBuilder.setTransactionGetRecord(this.builder.setHeader(header));
    }

    @Override
    ResponseHeader mapResponseHeader(Response response) {
        return response.getTransactionGetRecord().getHeader();
    }

    @Override
    QueryHeader mapRequestHeader(com.hedera.hashgraph.sdk.proto.Query request) {
        return request.getTransactionGetRecord().getHeader();
    }

    @Override
    TransactionRecord mapResponse(Response response, AccountId nodeId, com.hedera.hashgraph.sdk.proto.Query request) {
        return TransactionRecord.fromProtobuf(response.getTransactionGetRecord().getTransactionRecord());
    }

    @Override
    MethodDescriptor<com.hedera.hashgraph.sdk.proto.Query, Response> getMethodDescriptor() {
        return CryptoServiceGrpc.getGetTxRecordByTxIDMethod();
    }

    @Override
    boolean shouldRetry(Status status, Response response) {
        if (super.shouldRetry(status, response)) {
            return true;
        }
        if (status != Status.OK) {
            return false;
        }
        Status receiptStatus = Status.valueOf(response.getTransactionGetRecord().getTransactionRecord().getReceipt().getStatus());
        switch (receiptStatus) {
            case BUSY: 
            case UNKNOWN: 
            case OK: 
            case RECEIPT_NOT_FOUND: 
            case RECORD_NOT_FOUND: {
                return true;
            }
        }
        return false;
    }
}

