/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.EntityIdHelper;
import com.hedera.hashgraph.sdk.proto.AccountID;
import java.util.Objects;
import javax.annotation.Nonnegative;

public final class AccountId {
    @Nonnegative
    public final long shard;
    @Nonnegative
    public final long realm;
    @Nonnegative
    public final long num;

    public AccountId(@Nonnegative long num) {
        this(0L, 0L, num);
    }

    public AccountId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num) {
        this.shard = shard;
        this.realm = realm;
        this.num = num;
    }

    public static AccountId fromString(String id) {
        return EntityIdHelper.fromString(id, AccountId::new);
    }

    public static AccountId fromSolidityAddress(String address) {
        return EntityIdHelper.fromSolidityAddress(address, AccountId::new);
    }

    static AccountId fromProtobuf(AccountID accountId) {
        return new AccountId(accountId.getShardNum(), accountId.getRealmNum(), accountId.getAccountNum());
    }

    public static AccountId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return AccountId.fromProtobuf((AccountID)((AccountID.Builder)AccountID.parseFrom(bytes).toBuilder()).build());
    }

    public String toSolidityAddress() {
        return EntityIdHelper.toSolidityAddress(this.shard, this.realm, this.num);
    }

    AccountID toProtobuf() {
        return (AccountID)AccountID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm).setAccountNum(this.num).build();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        return this.shard + "." + this.realm + "." + this.num;
    }

    public int hashCode() {
        return Objects.hash(this.shard, this.realm, this.num);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccountId)) {
            return false;
        }
        AccountId otherId = (AccountId)o;
        return this.shard == otherId.shard && this.realm == otherId.realm && this.num == otherId.num;
    }
}

