/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.BoolValue;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.StringValue;
import com.google.protobuf.UInt64Value;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.CryptoUpdateTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class AccountUpdateTransaction
extends com.hedera.hashgraph.sdk.Transaction<AccountUpdateTransaction> {
    private final CryptoUpdateTransactionBody.Builder builder;

    public AccountUpdateTransaction() {
        this.builder = CryptoUpdateTransactionBody.newBuilder();
    }

    AccountUpdateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (CryptoUpdateTransactionBody.Builder)this.bodyBuilder.getCryptoUpdateAccount().toBuilder();
    }

    @Nullable
    public AccountId getAccountId() {
        return this.builder.hasAccountIDToUpdate() ? AccountId.fromProtobuf(this.builder.getAccountIDToUpdate()) : null;
    }

    public AccountUpdateTransaction setAccountId(AccountId accountId) {
        this.requireNotFrozen();
        this.builder.setAccountIDToUpdate(accountId.toProtobuf());
        return this;
    }

    @Nullable
    public Key getKey() {
        return this.builder.hasKey() ? Key.fromProtobufKey(this.builder.getKey()) : null;
    }

    public AccountUpdateTransaction setKey(Key key) {
        this.requireNotFrozen();
        this.builder.setKey(key.toProtobufKey());
        return this;
    }

    @Nullable
    public AccountId getProxyAccountId() {
        return this.builder.hasProxyAccountID() ? AccountId.fromProtobuf(this.builder.getProxyAccountID()) : null;
    }

    public AccountUpdateTransaction setProxyAccountId(AccountId proxyAccountId) {
        this.requireNotFrozen();
        this.builder.setProxyAccountID(proxyAccountId.toProtobuf());
        return this;
    }

    @Nullable
    Hbar getSendRecordThreshold() {
        return this.builder.hasSendRecordThresholdWrapper() ? Hbar.fromTinybars(this.builder.getSendRecordThresholdWrapper().getValue()) : null;
    }

    AccountUpdateTransaction setSendRecordThreshold(Hbar sendRecordThreshold) {
        this.requireNotFrozen();
        this.builder.setSendRecordThresholdWrapper(UInt64Value.of((long)sendRecordThreshold.toTinybars()));
        return this;
    }

    @Nullable
    Hbar getReceiveRecordThreshold() {
        return this.builder.hasReceiveRecordThresholdWrapper() ? Hbar.fromTinybars(this.builder.getReceiveRecordThresholdWrapper().getValue()) : null;
    }

    AccountUpdateTransaction setReceiveRecordThreshold(Hbar receiveRecordThreshold) {
        this.requireNotFrozen();
        this.builder.setReceiveRecordThresholdWrapper(UInt64Value.of((long)receiveRecordThreshold.toTinybars()));
        return this;
    }

    @Nullable
    public Instant getExpirationTime() {
        return this.builder.hasExpirationTime() ? InstantConverter.fromProtobuf(this.builder.getExpirationTime()) : null;
    }

    public AccountUpdateTransaction setExpirationTime(Instant expirationTime) {
        this.requireNotFrozen();
        this.builder.setExpirationTime(InstantConverter.toProtobuf(expirationTime));
        return this;
    }

    @Nullable
    public Duration getAutoRenewPeriod() {
        return this.builder.hasAutoRenewPeriod() ? DurationConverter.fromProtobuf(this.builder.getAutoRenewPeriod()) : null;
    }

    @Deprecated
    public AccountUpdateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        this.requireNotFrozen();
        this.builder.setAutoRenewPeriod(DurationConverter.toProtobuf(autoRenewPeriod));
        return this;
    }

    @Nullable
    public Boolean getReceiverSignatureRequired() {
        return this.builder.hasReceiverSigRequiredWrapper() ? Boolean.valueOf(this.builder.getReceiverSigRequiredWrapper().getValue()) : null;
    }

    public AccountUpdateTransaction setReceiverSignatureRequired(boolean receiverSignatureRequired) {
        this.requireNotFrozen();
        this.builder.setReceiverSigRequiredWrapper(BoolValue.of((boolean)receiverSignatureRequired));
        return this;
    }

    public String getAccountMemo() {
        return this.builder.getMemo().getValue();
    }

    public AccountUpdateTransaction setAccountMemo(String memo) {
        this.requireNotFrozen();
        this.builder.setMemo(StringValue.of((String)memo));
        return this;
    }

    public AccountUpdateTransaction clearMemo() {
        this.requireNotFrozen();
        this.builder.clearMemo();
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return CryptoServiceGrpc.getUpdateAccountMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setCryptoUpdateAccount(this.builder);
        return true;
    }
}

