/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.hedera.hashgraph.sdk.AccountBalanceQuery;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.MirrorNetwork;
import com.hedera.hashgraph.sdk.Network;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.PrivateKey;
import com.hedera.hashgraph.sdk.PublicKey;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class Client
implements AutoCloseable {
    private static final Hbar DEFAULT_MAX_QUERY_PAYMENT = new Hbar(1L);
    private static final Hbar DEFAULT_MAX_TRANSACTION_FEE = new Hbar(1L);
    Hbar maxTransactionFee = DEFAULT_MAX_QUERY_PAYMENT;
    Hbar maxQueryPayment = DEFAULT_MAX_TRANSACTION_FEE;
    Network network;
    MirrorNetwork mirrorNetwork;
    final ExecutorService executor;
    @Nullable
    private Operator operator;
    Duration requestTimeout = Duration.ofMinutes(2L);

    Client(Map<String, AccountId> network) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("hedera-sdk-%d").setDaemon(true).build();
        this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), threadFactory);
        this.network = new Network(this.executor, network);
        this.mirrorNetwork = new MirrorNetwork(this.executor);
    }

    public void setMirrorNetwork(List<String> network) throws InterruptedException {
        this.mirrorNetwork.setNetwork(network);
    }

    public List<String> getMirrorNetwork() {
        return this.mirrorNetwork.addresses;
    }

    public static Client forNetwork(Map<String, AccountId> network) {
        return new Client(network);
    }

    public static Client forName(String name) {
        switch (name) {
            case "mainnet": {
                return Client.forMainnet();
            }
            case "testnet": {
                return Client.forTestnet();
            }
            case "previewnet": {
                return Client.forPreviewnet();
            }
        }
        throw new IllegalArgumentException("Name must be one-of `mainnet`, `testnet`, or `previewnet`");
    }

    public static Client forMainnet() {
        HashMap<String, AccountId> network = new HashMap<String, AccountId>();
        network.put("35.237.200.180:50211", new AccountId(3L));
        network.put("35.186.191.247:50211", new AccountId(4L));
        network.put("35.192.2.25:50211", new AccountId(5L));
        network.put("35.199.161.108:50211", new AccountId(6L));
        network.put("35.203.82.240:50211", new AccountId(7L));
        network.put("35.236.5.219:50211", new AccountId(8L));
        network.put("35.197.192.225:50211", new AccountId(9L));
        network.put("35.242.233.154:50211", new AccountId(10L));
        network.put("35.240.118.96:50211", new AccountId(11L));
        network.put("35.204.86.32:50211", new AccountId(12L));
        Client client = Client.forNetwork(network);
        try {
            client.setMirrorNetwork(List.of("hcs.mainnet.mirrornode.hedera.com:5600"));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return client;
    }

    public static Client forTestnet() {
        HashMap<String, AccountId> network = new HashMap<String, AccountId>();
        network.put("0.testnet.hedera.com:50211", new AccountId(3L));
        network.put("1.testnet.hedera.com:50211", new AccountId(4L));
        network.put("2.testnet.hedera.com:50211", new AccountId(5L));
        network.put("3.testnet.hedera.com:50211", new AccountId(6L));
        Client client = Client.forNetwork(network);
        try {
            client.setMirrorNetwork(List.of("hcs.testnet.mirrornode.hedera.com:5600"));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return client;
    }

    public static Client forPreviewnet() {
        HashMap<String, AccountId> network = new HashMap<String, AccountId>();
        network.put("0.previewnet.hedera.com:50211", new AccountId(3L));
        network.put("1.previewnet.hedera.com:50211", new AccountId(4L));
        network.put("2.previewnet.hedera.com:50211", new AccountId(5L));
        network.put("3.previewnet.hedera.com:50211", new AccountId(6L));
        Client client = Client.forNetwork(network);
        try {
            client.setMirrorNetwork(List.of("hcs.previewnet.mirrornode.hedera.com:5600"));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return client;
    }

    public static Client fromConfig(String json) throws Exception {
        return Client.fromConfig(new StringReader(json));
    }

    public static Client fromConfig(Reader json) throws Exception {
        Client client;
        Object networks;
        Config config = (Config)new Gson().fromJson(json, Config.class);
        if (config.network == null) {
            throw new Exception("Network is not set in provided json object");
        }
        if (config.network.isJsonObject()) {
            networks = config.network.getAsJsonObject();
            Object nodes = new HashMap(networks.size());
            for (Map.Entry entry : networks.entrySet()) {
                nodes.put(((JsonElement)entry.getValue()).toString().replace("\"", ""), AccountId.fromString(((String)entry.getKey()).toString().replace("\"", "")));
            }
            client = new Client((Map<String, AccountId>)nodes);
        } else {
            switch (networks = config.network.getAsString()) {
                case "mainnet": {
                    client = Client.forMainnet();
                    break;
                }
                case "testnet": {
                    client = Client.forTestnet();
                    break;
                }
                case "previewnet": {
                    client = Client.forPreviewnet();
                    break;
                }
                default: {
                    throw new JsonParseException("Illegal argument for network.");
                }
            }
        }
        if (config.operator != null) {
            AccountId operatorAccount = AccountId.fromString(config.operator.accountId);
            PrivateKey privateKey = PrivateKey.fromString(config.operator.privateKey);
            client.setOperator(operatorAccount, privateKey);
        }
        if (config.mirrorNetwork != null) {
            if (config.mirrorNetwork.isJsonArray()) {
                JsonArray mirrors = config.mirrorNetwork.getAsJsonArray();
                ArrayList<String> listMirrors = new ArrayList<String>(mirrors.size());
                for (int i = 0; i < mirrors.size(); ++i) {
                    listMirrors.add(mirrors.get(i).getAsString().replace("\"", ""));
                }
                client.setMirrorNetwork(listMirrors);
            } else {
                String mirror;
                switch (mirror = config.mirrorNetwork.getAsString()) {
                    case "mainnet": {
                        client.setMirrorNetwork(List.of("hcs.mainnet.mirrornode.hedera.com:5600"));
                        break;
                    }
                    case "testnet": {
                        client.setMirrorNetwork(List.of("hcs.testnet.mirrornode.hedera.com:5600"));
                        break;
                    }
                    case "previewnet": {
                        client.setMirrorNetwork(List.of("hcs.previewnet.mirrornode.hedera.com:5600"));
                        break;
                    }
                    default: {
                        throw new JsonParseException("Illegal argument for mirrorNetwork.");
                    }
                }
            }
        }
        return client;
    }

    public static Client fromConfigFile(String fileName) throws Exception {
        return Client.fromConfigFile(new File(fileName));
    }

    public static Client fromConfigFile(File file) throws Exception {
        return Client.fromConfig(Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8));
    }

    public Client setNetwork(Map<String, AccountId> network) throws InterruptedException, TimeoutException {
        this.network.setNetwork(network);
        return this;
    }

    public Map<String, AccountId> getNetwork() {
        return this.network.network;
    }

    public void ping(AccountId nodeAccountId) throws TimeoutException, PrecheckStatusException {
        ((AccountBalanceQuery)new AccountBalanceQuery().setAccountId(nodeAccountId).setNodeAccountIds((List)Collections.singletonList(nodeAccountId))).execute(this);
    }

    public Client setOperator(AccountId accountId, PrivateKey privateKey) {
        return this.setOperatorWith(accountId, privateKey.getPublicKey(), privateKey::sign);
    }

    public Client setOperatorWith(AccountId accountId, PublicKey publicKey, Function<byte[], byte[]> transactionSigner) {
        this.operator = new Operator(accountId, publicKey, transactionSigner);
        return this;
    }

    @Nullable
    public AccountId getOperatorAccountId() {
        if (this.operator == null) {
            return null;
        }
        return this.operator.accountId;
    }

    @Nullable
    public PublicKey getOperatorPublicKey() {
        if (this.operator == null) {
            return null;
        }
        return this.operator.publicKey;
    }

    public Client setMaxTransactionFee(Hbar maxTransactionFee) {
        if (maxTransactionFee.toTinybars() < 0L) {
            throw new IllegalArgumentException("maxTransactionFee must be non-negative");
        }
        this.maxTransactionFee = maxTransactionFee;
        return this;
    }

    public Client setMaxQueryPayment(Hbar maxQueryPayment) {
        if (maxQueryPayment.toTinybars() < 0L) {
            throw new IllegalArgumentException("maxQueryPayment must be non-negative");
        }
        this.maxQueryPayment = maxQueryPayment;
        return this;
    }

    public Client setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Nullable
    Operator getOperator() {
        return this.operator;
    }

    @Override
    public synchronized void close() throws TimeoutException {
        this.close(Duration.ofSeconds(30L));
    }

    public void close(Duration timeout) throws TimeoutException {
        this.network.close(timeout);
        this.mirrorNetwork.close(timeout);
    }

    private String getUserAgent() {
        Package thePackage = this.getClass().getPackage();
        String implementationVersion = thePackage != null ? thePackage.getImplementationVersion() : null;
        return "hedera-sdk-java/" + (String)(implementationVersion != null ? "v" + implementationVersion : "DEV");
    }

    private static class Config {
        @Nullable
        private JsonElement network;
        @Nullable
        private ConfigOperator operator;
        @Nullable
        private JsonElement mirrorNetwork;

        private Config() {
        }

        private static class ConfigOperator {
            private String accountId = "";
            private String privateKey = "";

            private ConfigOperator() {
            }
        }
    }

    static class Operator {
        final AccountId accountId;
        final PublicKey publicKey;
        final Function<byte[], byte[]> transactionSigner;

        Operator(AccountId accountId, PublicKey publicKey, Function<byte[], byte[]> transactionSigner) {
            this.accountId = accountId;
            this.publicKey = publicKey;
            this.transactionSigner = transactionSigner;
        }
    }
}

