/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.ContractFunctionParameters;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ContractCreateTransactionBody;
import com.hedera.hashgraph.sdk.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class ContractCreateTransaction
extends com.hedera.hashgraph.sdk.Transaction<ContractCreateTransaction> {
    private final ContractCreateTransactionBody.Builder builder;

    public ContractCreateTransaction() {
        this.builder = ContractCreateTransactionBody.newBuilder();
        this.setAutoRenewPeriod(DEFAULT_AUTO_RENEW_PERIOD);
        this.setMaxTransactionFee(new Hbar(20L));
    }

    ContractCreateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.builder = (ContractCreateTransactionBody.Builder)this.bodyBuilder.getContractCreateInstance().toBuilder();
    }

    @Nullable
    public FileId getBytecodeFileId() {
        return this.builder.hasFileID() ? FileId.fromProtobuf(this.builder.getFileID()) : null;
    }

    public ContractCreateTransaction setBytecodeFileId(FileId byteCodeFileId) {
        this.requireNotFrozen();
        this.builder.setFileID(byteCodeFileId.toProtobuf());
        return this;
    }

    @Nullable
    public Key getAdminKey() {
        return this.builder.hasAdminKey() ? Key.fromProtobufKey(this.builder.getAdminKey()) : null;
    }

    public ContractCreateTransaction setAdminKey(Key adminKey) {
        this.requireNotFrozen();
        this.builder.setAdminKey(adminKey.toProtobufKey());
        return this;
    }

    public long getGas() {
        return this.builder.getGas();
    }

    public ContractCreateTransaction setGas(long gas) {
        this.requireNotFrozen();
        this.builder.setGas(gas);
        return this;
    }

    public Hbar getInitialBalance() {
        return Hbar.fromTinybars(this.builder.getInitialBalance());
    }

    public ContractCreateTransaction setInitialBalance(Hbar initialBalance) {
        this.requireNotFrozen();
        this.builder.setInitialBalance(initialBalance.toTinybars());
        return this;
    }

    @Nullable
    public AccountId getProxyAccountId() {
        return this.builder.hasProxyAccountID() ? AccountId.fromProtobuf(this.builder.getProxyAccountID()) : null;
    }

    public ContractCreateTransaction setProxyAccountId(AccountId proxyAccountId) {
        this.requireNotFrozen();
        this.builder.setProxyAccountID(proxyAccountId.toProtobuf());
        return this;
    }

    @Nullable
    public Duration getAutoRenewPeriod() {
        return this.builder.hasAutoRenewPeriod() ? DurationConverter.fromProtobuf(this.builder.getAutoRenewPeriod()) : null;
    }

    public ContractCreateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        this.requireNotFrozen();
        this.builder.setAutoRenewPeriod(DurationConverter.toProtobuf(autoRenewPeriod));
        return this;
    }

    public ByteString getConstructorParameters() {
        return this.builder.getConstructorParameters();
    }

    public ContractCreateTransaction setConstructorParameters(byte[] constructorParameters) {
        this.requireNotFrozen();
        this.builder.setConstructorParameters(ByteString.copyFrom((byte[])constructorParameters));
        return this;
    }

    public ContractCreateTransaction setConstructorParameters(ContractFunctionParameters constructorParameters) {
        this.requireNotFrozen();
        this.builder.setConstructorParameters(constructorParameters.toBytes(null));
        return this;
    }

    public String getContractMemo() {
        return this.builder.getMemo();
    }

    public ContractCreateTransaction setContractMemo(String memo) {
        this.requireNotFrozen();
        this.builder.setMemo(memo);
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return SmartContractServiceGrpc.getCreateContractMethod();
    }

    @Override
    boolean onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setContractCreateInstance(this.builder);
        return true;
    }
}

