/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.errorprone.annotations.Var;
import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.ContractFunctionSelector;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;

public final class ContractFunctionParameters {
    public static final int ADDRESS_LEN = 20;
    public static final int ADDRESS_LEN_HEX = 40;
    public static final int SELECTOR_LEN = 4;
    public static final int SELECTOR_LEN_HEX = 8;
    private static final ByteString padding = ByteString.copyFrom((byte[])new byte[31]);
    private static final ByteString negativePadding;
    private final ArrayList<Argument> args = new ArrayList();

    private static ByteString encodeString(String string) {
        ByteString strBytes = ByteString.copyFromUtf8((String)string);
        return ContractFunctionParameters.int256(strBytes.size(), 32).concat(ContractFunctionParameters.rightPad32(strBytes));
    }

    private static ByteString encodeBytes(byte[] bytes) {
        return ContractFunctionParameters.int256(bytes.length, 32).concat(ContractFunctionParameters.rightPad32(ByteString.copyFrom((byte[])bytes)));
    }

    private static ByteString encodeBytes32(byte[] bytes) {
        if (bytes.length > 32) {
            throw new IllegalArgumentException("byte32 encoding forbids byte array length greater than 32");
        }
        return ContractFunctionParameters.rightPad32(ByteString.copyFrom((byte[])bytes));
    }

    private static ByteString encodeArray(Stream<ByteString> elements) {
        List list = elements.collect(Collectors.toList());
        return ContractFunctionParameters.int256(list.size(), 32).concat(ByteString.copyFrom(list));
    }

    private static ByteString encodeDynArr(List<ByteString> elements) {
        int offsetsLen = elements.size();
        ArrayList<ByteString> head = new ArrayList<ByteString>(offsetsLen + 1);
        head.add(ContractFunctionParameters.uint256(elements.size(), 32));
        long currOffset = (long)offsetsLen * 32L;
        for (ByteString elem : elements) {
            head.add(ContractFunctionParameters.uint256(currOffset, 64));
            currOffset += (long)elem.size();
        }
        return ByteString.copyFrom(head).concat(ByteString.copyFrom(elements));
    }

    private static void checkBigInt(BigInteger val) {
        if (val.bitLength() > 255) {
            throw new IllegalArgumentException("BigInteger out of range for Solidity integers");
        }
    }

    private static void checkBigUint(BigInteger val) {
        if (val.signum() < 0) {
            throw new IllegalArgumentException("negative BigInteger passed to unsigned function");
        }
        if (val.bitLength() > 256) {
            throw new IllegalArgumentException("BigInteger out of range for Solidity integers");
        }
    }

    static ByteString int256(long val, int bitWidth) {
        return ContractFunctionParameters.int256(val, bitWidth, true);
    }

    static ByteString int256(long val, @Var int bitWidth, boolean signed) {
        bitWidth = Math.min(bitWidth, 64);
        ByteString.Output output = ByteString.newOutput((int)(bitWidth / 8));
        for (int i = bitWidth - 8; i >= 0; i -= 8) {
            byte u8 = (byte)(val >> i);
            output.write((int)u8);
        }
        return ContractFunctionParameters.leftPad32(output.toByteString(), signed && val < 0L);
    }

    static ByteString int256(BigInteger bigInt) {
        return ContractFunctionParameters.leftPad32(bigInt.toByteArray(), bigInt.signum() < 0);
    }

    static ByteString uint256(long val, int bitWidth) {
        return ContractFunctionParameters.int256(val, bitWidth, false);
    }

    static ByteString uint256(BigInteger bigInt) {
        if (bigInt.bitLength() == 256) {
            return ByteString.copyFrom((byte[])bigInt.toByteArray(), (int)1, (int)32);
        }
        return ContractFunctionParameters.leftPad32(bigInt.toByteArray(), false);
    }

    static ByteString leftPad32(ByteString input) {
        return ContractFunctionParameters.leftPad32(input, false);
    }

    static ByteString leftPad32(ByteString input, boolean negative) {
        int rem = 32 - input.size() % 32;
        return rem == 32 ? input : (negative ? negativePadding : padding).substring(0, rem).concat(input);
    }

    static ByteString leftPad32(byte[] input, boolean negative) {
        return ContractFunctionParameters.leftPad32(ByteString.copyFrom((byte[])input), negative);
    }

    static ByteString rightPad32(ByteString input) {
        int rem = 32 - input.size() % 32;
        return rem == 32 ? input : input.concat(padding.substring(0, rem));
    }

    private static byte[] decodeAddress(@Var String address) {
        String string = address = address.startsWith("0x") ? address.substring(2) : address;
        if (address.length() != 40) {
            throw new IllegalArgumentException("Solidity addresses must be 40 hex chars");
        }
        try {
            return Hex.decode((String)address);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("failed to decode Solidity address as hex", e);
        }
    }

    public ContractFunctionParameters addString(String param) {
        this.args.add(new Argument("string", ContractFunctionParameters.encodeString(param), true));
        return this;
    }

    public ContractFunctionParameters addStringArray(String[] strings) {
        List<ByteString> byteStrings = Arrays.stream(strings).map(ContractFunctionParameters::encodeString).collect(Collectors.toList());
        ByteString argBytes = ContractFunctionParameters.encodeDynArr(byteStrings);
        this.args.add(new Argument("string[]", argBytes, true));
        return this;
    }

    public ContractFunctionParameters addBytes(byte[] param) {
        this.args.add(new Argument("bytes", ContractFunctionParameters.encodeBytes(param), true));
        return this;
    }

    public ContractFunctionParameters addBytesArray(byte[][] param) {
        List<ByteString> byteArrays = Arrays.stream(param).map(ContractFunctionParameters::encodeBytes).collect(Collectors.toList());
        this.args.add(new Argument("bytes[]", ContractFunctionParameters.encodeDynArr(byteArrays), true));
        return this;
    }

    public ContractFunctionParameters addBytes32(byte[] param) {
        this.args.add(new Argument("bytes32", ContractFunctionParameters.encodeBytes32(param), false));
        return this;
    }

    public ContractFunctionParameters addBytes32Array(byte[][] param) {
        Stream<ByteString> byteArrays = Arrays.stream(param).map(ContractFunctionParameters::encodeBytes32);
        this.args.add(new Argument("bytes32[]", ContractFunctionParameters.encodeArray(byteArrays), true));
        return this;
    }

    public ContractFunctionParameters addBool(boolean bool) {
        this.args.add(new Argument("bool", ContractFunctionParameters.int256(bool ? 1L : 0L, 8), false));
        return this;
    }

    public ContractFunctionParameters addInt8(byte value) {
        this.args.add(new Argument("int8", ContractFunctionParameters.int256(value, 32), false));
        return this;
    }

    public ContractFunctionParameters addInt32(int value) {
        this.args.add(new Argument("int32", ContractFunctionParameters.int256(value, 32), false));
        return this;
    }

    public ContractFunctionParameters addInt64(long value) {
        this.args.add(new Argument("int64", ContractFunctionParameters.int256(value, 64), false));
        return this;
    }

    public ContractFunctionParameters addInt256(BigInteger bigInt) {
        ContractFunctionParameters.checkBigInt(bigInt);
        this.args.add(new Argument("int256", ContractFunctionParameters.int256(bigInt), false));
        return this;
    }

    public ContractFunctionParameters addInt8Array(byte[] intArray) {
        IntStream intStream = IntStream.range(0, intArray.length).map(idx -> intArray[idx]);
        ByteString arrayBytes = ByteString.copyFrom((Iterable)intStream.mapToObj(i -> ContractFunctionParameters.int256(i, 8)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int8[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt32Array(int[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.int256(i, 32)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("int32[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt64Array(long[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.int256(i, 64)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 64).concat(arrayBytes);
        this.args.add(new Argument("int64[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addInt256Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(ContractFunctionParameters::int256).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 256).concat(arrayBytes);
        this.args.add(new Argument("int256[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint8(byte value) {
        this.args.add(new Argument("uint8", ContractFunctionParameters.uint256(value, 8), false));
        return this;
    }

    public ContractFunctionParameters addUint32(int value) {
        this.args.add(new Argument("uint32", ContractFunctionParameters.uint256(value, 32), false));
        return this;
    }

    public ContractFunctionParameters addUint64(long value) {
        this.args.add(new Argument("uint64", ContractFunctionParameters.uint256(value, 64), false));
        return this;
    }

    public ContractFunctionParameters addUint256(@Nonnegative BigInteger bigUint) {
        ContractFunctionParameters.checkBigUint(bigUint);
        this.args.add(new Argument("uint256", ContractFunctionParameters.uint256(bigUint), false));
        return this;
    }

    public ContractFunctionParameters addUint8Array(byte[] intArray) {
        IntStream intStream = IntStream.range(0, intArray.length).map(idx -> intArray[idx]);
        ByteString arrayBytes = ByteString.copyFrom((Iterable)intStream.mapToObj(i -> ContractFunctionParameters.uint256(i, 8)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint8[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint32Array(int[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.uint256(i, 32)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 32).concat(arrayBytes);
        this.args.add(new Argument("uint32[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint64Array(long[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).mapToObj(i -> ContractFunctionParameters.uint256(i, 64)).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 64).concat(arrayBytes);
        this.args.add(new Argument("uint64[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addUint256Array(BigInteger[] intArray) {
        ByteString arrayBytes = ByteString.copyFrom((Iterable)Arrays.stream(intArray).map(ContractFunctionParameters::uint256).collect(Collectors.toList()));
        arrayBytes = ContractFunctionParameters.uint256(intArray.length, 256).concat(arrayBytes);
        this.args.add(new Argument("uint256[]", arrayBytes, true));
        return this;
    }

    public ContractFunctionParameters addAddress(String address) {
        byte[] addressBytes = ContractFunctionParameters.decodeAddress(address);
        this.args.add(new Argument("address", ContractFunctionParameters.leftPad32(ByteString.copyFrom((byte[])addressBytes)), false));
        return this;
    }

    public ContractFunctionParameters addAddressArray(String[] addresses) {
        ByteString addressArray = ContractFunctionParameters.encodeArray(Arrays.stream(addresses).map(a -> {
            byte[] address = ContractFunctionParameters.decodeAddress(a);
            return ContractFunctionParameters.leftPad32(ByteString.copyFrom((byte[])address));
        }));
        this.args.add(new Argument("address[]", addressArray, true));
        return this;
    }

    public ContractFunctionParameters addFunction(String address, byte[] selector) {
        return this.addFunction(ContractFunctionParameters.decodeAddress(address), selector);
    }

    public ContractFunctionParameters addFunction(String address, ContractFunctionSelector selector) {
        return this.addFunction(ContractFunctionParameters.decodeAddress(address), selector.finish());
    }

    private ContractFunctionParameters addFunction(byte[] address, byte[] selector) {
        if (selector.length != 4) {
            throw new IllegalArgumentException("function selectors must be 4 bytes or 8 hex chars");
        }
        ByteString.Output output = ByteString.newOutput((int)24);
        output.write(address, 0, address.length);
        output.write(selector, 0, selector.length);
        this.args.add(new Argument("function", ContractFunctionParameters.rightPad32(output.toByteString()), false));
        return this;
    }

    ByteString toBytes(@Nullable String funcName) {
        int dynamicOffset = this.args.size() * 32;
        ArrayList<Object> paramsBytes = new ArrayList<Object>(this.args.size() + 1);
        ArrayList<ByteString> dynamicArgs = new ArrayList<ByteString>();
        ContractFunctionSelector functionSelector = funcName != null ? new ContractFunctionSelector(funcName) : null;
        for (Argument arg : this.args) {
            if (functionSelector != null) {
                functionSelector.addParamType(arg.type);
            }
            if (arg.isDynamic) {
                paramsBytes.add(ContractFunctionParameters.int256(dynamicOffset, 256));
                dynamicArgs.add(arg.value);
                dynamicOffset += arg.value.size();
                continue;
            }
            paramsBytes.add(arg.value);
        }
        if (functionSelector != null) {
            paramsBytes.add(0, ByteString.copyFrom((byte[])functionSelector.finish()));
        }
        paramsBytes.addAll(dynamicArgs);
        return ByteString.copyFrom(paramsBytes);
    }

    static {
        byte[] fill = new byte[31];
        Arrays.fill(fill, (byte)-1);
        negativePadding = ByteString.copyFrom((byte[])fill);
    }

    private static final class Argument {
        private final String type;
        private final ByteString value;
        private final boolean isDynamic;

        private Argument(String type, ByteString value, boolean isDynamic) {
            this.type = type;
            if (!isDynamic && value.size() != 32) {
                throw new IllegalArgumentException("value argument that was not 32 bytes");
            }
            this.value = value;
            this.isDynamic = isDynamic;
        }
    }
}

