/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.EntityIdHelper;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.proto.ContractID;
import java.util.Objects;
import javax.annotation.Nonnegative;

public final class ContractId
extends Key {
    @Nonnegative
    public final long shard;
    @Nonnegative
    public final long realm;
    @Nonnegative
    public final long num;

    public ContractId(@Nonnegative long num) {
        this(0L, 0L, num);
    }

    public ContractId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num) {
        this.shard = shard;
        this.realm = realm;
        this.num = num;
    }

    public static ContractId fromString(String id) {
        return EntityIdHelper.fromString(id, ContractId::new);
    }

    public static ContractId fromSolidityAddress(String address) {
        return EntityIdHelper.fromSolidityAddress(address, ContractId::new);
    }

    static ContractId fromProtobuf(ContractID contractId) {
        return new ContractId(contractId.getShardNum(), contractId.getRealmNum(), contractId.getContractNum());
    }

    public static ContractId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return ContractId.fromProtobuf((ContractID)((ContractID.Builder)ContractID.parseFrom(bytes).toBuilder()).build());
    }

    public String toSolidityAddress() {
        return EntityIdHelper.toSolidityAddress(this.shard, this.realm, this.num);
    }

    ContractID toProtobuf() {
        return (ContractID)ContractID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm).setContractNum(this.num).build();
    }

    @Override
    com.hedera.hashgraph.sdk.proto.Key toProtobufKey() {
        return (com.hedera.hashgraph.sdk.proto.Key)com.hedera.hashgraph.sdk.proto.Key.newBuilder().setContractID(this.toProtobuf()).build();
    }

    @Override
    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        return this.shard + "." + this.realm + "." + this.num;
    }

    public int hashCode() {
        return Objects.hash(this.shard, this.realm, this.num);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContractId)) {
            return false;
        }
        ContractId otherId = (ContractId)o;
        return this.shard == otherId.shard && this.realm == otherId.realm && this.num == otherId.num;
    }
}

