/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.proto.ContractLoginfo;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public final class ContractLogInfo {
    public final ContractId contractId;
    public final ByteString bloom;
    public final List<ByteString> topics;
    public final ByteString data;

    private ContractLogInfo(ContractId contractId, ByteString bloom, List<ByteString> topics, ByteString data) {
        this.contractId = contractId;
        this.bloom = bloom;
        this.topics = topics;
        this.data = data;
    }

    static ContractLogInfo fromProtobuf(ContractLoginfo logInfo) {
        return new ContractLogInfo(ContractId.fromProtobuf(logInfo.getContractID()), logInfo.getBloom(), logInfo.getTopicList(), logInfo.getData());
    }

    ContractLoginfo toProtobuf() {
        ContractLoginfo.Builder contractLogInfo = ContractLoginfo.newBuilder().setContractID(this.contractId.toProtobuf()).setBloom(this.bloom);
        for (ByteString topic : this.topics) {
            contractLogInfo.addTopic(topic);
        }
        return (ContractLoginfo)contractLogInfo.build();
    }

    public static ContractLogInfo fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return ContractLogInfo.fromProtobuf(ContractLoginfo.parseFrom(bytes));
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)this).add("contractId", (Object)this.contractId).add("bloom", (Object)Hex.toHexString((byte[])this.bloom.toByteArray()));
        ArrayList<String> topicList = new ArrayList<String>();
        for (ByteString topic : this.topics) {
            topicList.add(Hex.toHexString((byte[])topic.toByteArray()));
        }
        return stringHelper.add("topics", topicList).toString();
    }
}

